# ui-siteentry.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vat/ui-siteentry.tcl,v 1.6 2002/02/03 04:30:33 lim Exp $


import RtpStatWindow ErrorWindow InfoWindow MtraceWindow

#FIXME much of the SiteEntry code can be shared with vic ActiveSource

#
SiteEntry instproc stats {} {
	$self instvar src_
	return "Kilobits [expr [$src_ layer-stat nb_] >> (10-3)] \
		Frames [$src_ layer-stat nf_] \
		Packets [$src_ layer-stat np_] \
		Missing [$src_ missing] \
		Misordered [$src_ layer-stat nm_] \
		Runts [$src_ layer-stat nrunt_] \
		Dups [$src_ layer-stat ndup_] \
		Bad-S-Len [$src_ set badsesslen_] \
		Bad-S-Ver [$src_ set badsessver_] \
		Bad-S-Opt [$src_ set badsessopt_] \
		Bad-Sdes [$src_ set badsdes_] \
		Bad-Bye [$src_ set badbye_]"
}

#
SiteEntry instproc decoder-stats {} {
	$self instvar src_
	set d [$src_ handler]
	#FIXME
	return [$d stats]
}

#
SiteEntry instproc delete-info-window {} {
	$self instvar info_win_
	delete $info_win_
	unset info_win_
}

#
SiteEntry instproc create-rtp-window {} {
	$self instvar src_ rtp_win_
	if [info exists rtp_win_] {
		$self delete-rtp-window
	} else {
		set rtp_win_ [new RtpStatWindow .rtp$src_ $src_ \
					"RTP Statistics" \
					"$self stats" \
					"$self delete-rtp-window"]
	}
}

#
SiteEntry instproc delete-rtp-window {} {
	$self instvar rtp_win_
	delete $rtp_win_
	unset rtp_win_
}

#
SiteEntry instproc create-decoder-window {} {
	$self instvar src_ decoder_win_
	if [info exists decoder_win_] {
		$self delete-decoder-window
	} else {
		if { "[$src_ handler]" == "" } {
			new ErrorWindow "no decoder stats yet"
			return
		}
		set decoder_win_ [new RtpStatWindow .decoder$src_ $src_  \
				"Decoder Statistics" \
				"$self decoder-stats" \
				"$self delete-decoder-window"]
	}
}

#
SiteEntry instproc delete-decoder-window {} {
	$self instvar decoder_win_
	delete $decoder_win_
	unset decoder_win_
}

#
SiteEntry instproc toggle-mute {} {
	$self instvar src_
	set v [expr ![$src_ mute]]
	$src_ mute $v
	$self mute $v
}

#
SiteEntry instproc build-info-menu {m x y parent} {
        catch {destroy $m}
        menu $m
        set f [$self get_option smallfont]
        $m add command -label "Site Info" \
                -command "$self toggle-info" -font $f
        $m add command -label "RTP Stats"\
                -command "$self create-rtp-window" -font $f
        $m add command -label "Decoder Stats" \
                -command "$self create-decoder-window" -font $f
        if [in_multicast [[$parent set agent_] session-addr]] {
                $m add command -label "Mtrace from" \
                        -command "$self create-mtrace-window from" -font $f
                $m add command -label "Mtrace to" \
                        -command "$self create-mtrace-window to" -font $f
        }
        $parent instvar scuba_sess_
        if [info exists scuba_sess_] {
                $m add command -label "Scuba Info" -font $f \
                        -command "$self create-scuba-window"
        }
    tk_popup $m $x $y
}

#
SiteEntry instproc toggle-info {} {
	$self instvar src_ info_win_
	if [info exists info_win_] {
		$self delete-info-window
	} else {
		set info_win_ [new InfoWindow .info$src_ $src_ $self]
	}
}

#
SiteEntry instproc create-mtrace-window {dir} {
        $self instvar mtrace_win_ src_
        set w .mtrace$src_
        if ![winfo exists $w] {
                set mtrace_win_ [new MtraceWindow $w $src_ $self]
        }
        $mtrace_win_ do_mtrace
}

#
SiteEntry instproc source {} {
	return [$self set src_]
}

