# ui-main.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vat/ui-main.tcl,v 1.67 2002/02/03 04:30:33 lim Exp $


import CuesSender Sitebox AudioPanel AudioControlMenu VatHelpWindow \
		Rank SiteName Configuration Observer HelpWindow mashutils \
		ErrorWindow

#FIXME
proc mark_icon args {}

#
# The main user interface for the vat application.
#
Class VatUI -superclass Observer -configuration {
	sessionType rtp
	speakerMute false
	inputPort {mike microphone mic}
	outputPort {speaker wave}
	mikeAGC false
	speakerAGC false
	buttonforeground gray40
}

#
# A toggle-able dismissable toplevel window for displaying a bulleted list of tips to help the vat user.
#
Class VatHelpWindow -superclass HelpWindow

VatUI instproc audio_psetup {} {
	$self instvar agent_
	$agent_ instvar controller_
	set s [$agent_ get_input_gain]
	puts "Vat.[lindex $s 0]Gain:	[lindex $s 1]"
	set s [$agent_ get_output_gain]
	puts "Vat.[lindex $s 0]Gain:	[lindex $s 1]"
	if ![info exists controller_] return
	set s [$controller_ agc-input]
	if [lindex $s 0] {
		puts "Vat.mikeAGCLevel:	[lindex $s 1]"
	}
	set s [$controller_ agc-output]
	if [lindex $s 0] {
		puts "Vat.speakerAGCLevel:	[lindex $s 1]"
	}
}

#
# Set the handler for each of the SiteNames to "lecture-mode" based on the boolean value <i>v</i>.
#
VatUI instproc set_lecture_mode v {
	$self instvar src_name_
	foreach s [array names src_name_] {
		set h [$s handler]
		if { $h != "" } {
			$h lecture-mode $v
		}
	}
}

#
# Create a bar in widget, <i>w</i>, with a title to the left and three buttons to the right: <br>
#    <dd> a "Settings" button to toggle the supplied <i>controlWindow</i>
#    <dd> a "Help" button to toggle the supplied <i>helpWindow</i>
#    <dd> a "Quit" button to execute the supplied <i>exitCmd</i>
#
VatUI instproc build.bar { w controlWindow helpWindow exitCmd } {
	set title "[$self get_option appname] v[version]"
	label $w.title -text $title -font [$self get_option ctrlFont] \
		-relief flat -justify left -width 30
	# used to set width to [string length $title]
	# but that was when the title was hardcoded to a global "MASH Demo: LBL vat v[version]"
	button $w.quit -text Quit -relief raised \
		-font [$self get_option ctrlFont] -command $exitCmd \
		-highlightthickness 1
	button $w.menu -text Settings -relief raised \
		-font [$self get_option ctrlFont] -highlightthickness 1 \
		-command "$controlWindow toggle"
	button $w.help -text Help -relief raised \
		-font [$self get_option ctrlFont] -highlightthickness 1 \
		-command "$helpWindow toggle"

	pack $w.title -side left -fill both -expand 1
	pack $w.menu $w.help $w.quit -side left -pady 1 -padx 1

	$self instvar titleBar_
	set titleBar_ $w.title
}

#
# Add cues buttons to the interface so that the vat user can send cues.
#
VatUI instproc build.cues { w } {
	$self instvar agent_ cs_ globalChannel_

	# tell cues which global coordination bus to use
	CuesSender set_cb $globalChannel_

	# figure out the cname of this vat's user
	set cname [[$agent_ set local_] sdes cname]

	# create a cues sender
	# this also make cues buttons user interface and
	# attach it to vat's ui
	set cs_ [new CuesSender $w $cname]
}

#
# Called by AudioArbiter through the observer mechanism to set the font of the title.
#
VatUI instproc arbiter_have v {
	$self instvar titleBar_
	if $v {
		$titleBar_ configure -font [$self get_option ctrlFont]

		# we may have incorrect duplex mode in the ControlMenu
		# update it
		$self instvar controlMenu_
		$controlMenu_ update_duplex
	} else {
		$titleBar_ configure -font [$self get_option noAudioFont]
	}
}

#
# Called by AudioArbiter through the observer mechanism.
#
VatUI instproc arbiter_snatch {} {
	$self instvar controlMenu_
	if [$controlMenu_ query autoRaise] {
		raise .
	}
}

#
# If <i>v</i> is true, mute user's input and undo the AudioPanel's
# 3rd-mouse-button binding for speaking.
#
VatUI instproc set_recv_only v {
	$self instvar audioPanel_
	$audioPanel_ set_recv_only $v
	if !$v {
		bind all <ButtonPress-3> "$audioPanel_ ptt-press"
		bind all <ButtonRelease-3> "$audioPanel_ ptt-release"
	} else {
		bind all <ButtonPress-3> ""
		bind all <ButtonRelease-3> ""
	}
}

#
# Create a Sitebox, an AudioPanel, and an AudioControlMenu inside
# widget, <i>w</i>, for the AudioAgent, <i>agent</i>.  (The caller is
# responsible for instantiating and packing <i>w</i>.)
#
# <p>
# Does any initialization that needs to wait for Controller
# object to be built.  Happens after mktk called, just
# before Tk_MainLoop is called.
#
VatUI instproc init { w globalChannel agent exitCmd spec } {
	$self next
	$self add_default ctrlFont [$self get_option helv10b]
	$self instvar controlMenu_ agent_ globalChannel_
	set agent_ $agent
	set globalChannel_ $globalChannel

	global mash
	if { ![info exists mash(environ)] || $mash(environ)!="mplug" } {
	    wm withdraw .
	}
	update idletasks
	global minwidth minheight
	set minwidth [winfo reqwidth .]
	set minheight [winfo reqheight .]
	wm minsize . $minwidth $minheight

	#
	# emulate implicit keyboard focus
	#
	bind $w <Enter> { focus %W }

	#wm focusmodel $w active
	bind $w q "$exitCmd"
	bind $w <Control-c> "$exitCmd"
	bind $w <Control-d> "$exitCmd"
        wm protocol . WM_DELETE_WINDOW "$exitCmd"

	bind $w p "$self audio_psetup"
	bind $w P "$self audio_psetup"

	frame $w.m
	frame $w.m.left
	frame $w.m.right
	frame $w.m.left.sites -relief raised -borderwidth 2

	$self instvar sitebox_
	set sitebox_ [new Sitebox $w.m.left.sites.sb $agent]

	pack $w.m.left.sites -expand 1 -fill both
	pack $w.m.left.sites.sb -expand 1 -fill both

	set a $w.m.right
	frame $a.ab

	$self instvar audioPanel_
	set audioPanel_ [new AudioPanel $a.ab $agent]
	set controlMenu_ [new AudioControlMenu $agent $self $audioPanel_]

	frame $w.bar -relief ridge -borderwidth 2
	$self build.bar $w.bar $controlMenu_ [new VatHelpWindow .vathelp] "$exitCmd"

	bind $w c "$sitebox_ purge"
	bind $w C "$sitebox_ purge"
	bind $w l "$sitebox_ list"
	bind $w L "$sitebox_ list"

	#
	# Setup sitebox bindings
	#
	bind $w o "$sitebox_ sort"
	bind $w O "$sitebox_ sort"


	pack $a.ab -expand 1 -fill both

	pack $w.m.left -side left -expand 1 -fill both
	pack $w.m.right -side left -fill y

	pack $w.m -expand 1 -fill both

	#
	# Build cues menu if specified by the user
	#
	if { [$self yesno useCues] } {
		frame $w.cues -relief ridge -borderwidth 2
		label $w.cues.l -font [$self get_option ctrlFont] \
			-text "Cues:"
		pack $w.cues.l -side left -padx 10

		$self build.cues $w.cues
		pack $w.cues -fill x
	}

	pack $w.bar -fill x

	set v [$self get_option geometry]
	if { $v != "" } {
		if { [ catch "wm geometry . $v" ] } {
			puts "[$self get_option appname]: bad geometry $v"
			exit
		}
	}

	#
	# postpone until all the sub-windows are mapped
	#
	# what was this for? commenting out since doesn't do anything and generates error in mui
	#bind $w <Map> { mark_icon "" }

	$self instvar rank_
	set rank_ [new Rank]

	global keepAudioButton
	if [$self yesno keepAudio] {
		$keepAudioButton invoke
	}

	#FIXME
	if [$self yesno speakerMute] {
		$outputMutebutton invoke
	}

	global inputAGCbutton outputAGCbutton
	if [$self yesno mikeAGC] {
		#FIXME NOT YET $AGCbutton(input) invoke
	}
	if [$self yesno speakerAGC] {
		#FIXME NOT YET $AGCbutton(output) invoke
	}

	#FIXME
	global inputPortButton outputPortButton inputScale outputScale
	set ports [$agent get_input_ports]
	if { [llength $ports] <= 1 } {
		$inputPortButton configure -state disabled \
			-disabledforeground [$self get_option buttonforeground]
	}
	set plist [$self get_option inputPort]
	set pname ""
	foreach elt $plist {
		if {[lsearch [string tolower $ports] $elt] >= 0} {
			set pname $elt
		}
	}
	if { $pname == "" } {
		set pname [lindex $ports 0]
	}
	$audioPanel_ setPort input $inputPortButton $inputScale $pname

	set ports [$agent get_output_ports]
	if { [llength $ports] <= 1 } {
		$outputPortButton configure -state disabled \
			-disabledforeground [$self get_option buttonforeground]
	}
	set plist [$self get_option outputPort]
	set pname ""
	foreach elt $plist {
		if {[lsearch [string tolower $ports] $elt] >= 0} {
			set pname $elt
		}
	}
	if { $pname == "" } {
		set pname [lindex $ports 0]
	}
	$audioPanel_ setPort output $outputPortButton $outputScale $pname

	#FIXME
	set a [$audioPanel_ set arbiter_]
	$a attach_observer $self
	$a indicator_update

	update idletasks
	global mash
	if { ![info exists mash(environ)] || $mash(environ)!="mplug" } {
	    wm deiconify .
	}

	# set the window & icon title from the conference name
	if { $spec == "" } {
		set conf "Contacting MeGa..."
	} else {
		set conf [$self get_option conferenceName]
	}
	$self window-title [$self get_option iconPrefix] $conf

	$agent_ attach $self
}

#
VatUI instproc reset {} {
	$self new_hostspec

	set conf [$self get_option conferenceName]
	$self window-title [$self get_option iconPrefix] $conf
}

#
# Generate a new_hostspec for the ControlMenu.
#
VatUI instproc new_hostspec {} {
	$self instvar controlMenu_
	$controlMenu_ new_hostspec
}

#
# Delete the Rank and Sitebox.
# Detach the UI object from all the agents it is attached to
#
VatUI instproc destroy {} {
	$self instvar rank_ sitebox_ audioPanel_ agent_
	set a [$audioPanel_ set arbiter_]
	$a detach_observer $self
	$agent_ detach $self
	delete $rank_
	delete $sitebox_
	$self next
}

#FIXME
proc xctrlFont { } {
	return [option get . ctrlFont Vat]
}

proc xctitlefont { } {
	return [option get . ctrlTitleFont Vat]
}

#
# Instantiate, but do not yet display or iconify, a dismissable toplevel
# window using the provided widgetpath, <i>w</i>.  Within <i>w</i>,
# create a bulleted list of tips to help the vat user.  (This method is
# called when the user toggles this window for the first time.)
#
VatHelpWindow instproc build w {

	$self create-window $w "Help" {

"Before transmitting audio, adjust the mike \
level so that the output meter peaks around 80% of full scale.  Below this\
you are hard to hear and above this your signal is distorted."

"To talk, temporarily unmute the mike by depressing\
the right mouse button anywhere in the vat window.  The mike is\
live only while the button is depressed.  For hands-free operation,\
you can leave the mike active by selecting the ``talk'' button\
above the mike icon. \
If the ``talk'' button is grayed-out, the ``recvOnly'' option is\
probably selected on the ``Menu'' panel."

"Mute individual sites by clicking on checkbox next to name."

"If your computer supports multiple audio input or output ports,
you can select which you want by clicking on mike or speaker icon."

"Prevent other vats from taking the audio device\
by clicking on the ``Keep Audio'' button.  Different vats will\
cooperate so that only one instance ever has ``Keep Audio'' selected. \
The vat label (at the bottom of the window) is italicized when\
this vat does not have control of the audio."

"Get info about a site by\
clicking (and holding) left mouse button over the site name. \
A popup menu lets you select a site description window, RTP and\
decoder statistics windows (various reception statistics for data\
coming from the site), and the `mtrace' (multicast traceroute)\
diagnostic run from the site to you or from you to the site."

"In a statistics window (the window you get by selecting either RTP\
or Decoder stats in the site popup menu), clicking the left button\
on a stat name will bring up a stripchart plotting that stat. \
The stat value is plotted every second. \
The horizontal axis has a tickmark (a vertical white\
line plotted *under* the data) every 30 seconds. \
A legend at the bottom of the window gives the vertical axis scale."

"If the user interface looks peculiar, you might\
have X resources that conflict with tk.  A common problem is\
defining ``*background'' and/or ``*foreground''."

"Bugs and suggestions to openmash-users@openmash.org.  Thanks."
	}
}

#
# Create a SiteName in the Sitebox for the supplied source, <i>src</i>.
# Configure whether or not the source should be muted based on the
# ControlMenu's setting for "mute new sites".
#
VatUI instproc create_src_name src {
	$self instvar src_name_ sitebox_ controlMenu_
	set startMuted [$controlMenu_ query muteNewSites]
	set src_name_($src) [new SiteName $src $sitebox_ $startMuted]
	$self trigger_sdes $src
}

#
# Create a SiteName for the supplied source, <i>src</i>, in the Sitebox
# if we display everyone (i.e., non-mixers and mixers).
#
VatUI instproc register src {
	#
	# if we display everyone (i.e., non-mixers and mixers),
	# then just create the name in the sitebox.  otherwise,
	# it gets deferred until we receive an SDES packet
	# (which never happens for a mixer) and trigger_sdes
	# gets called (or activate gets called because that site
	# is speaking in which case we have no choice but to
	# put up the non-sdes-style name up).
	#
	$self instvar agent_
	if { [$self yesno displayMixers] || "$src" == [$agent_ local] } {
		$self create_src_name $src
	}
}

#
# Keep the sites in the Sitebox sorted if <i>sense</i> is true.
#
VatUI instproc keep-sorted sense {
	[$self set sitebox_] keep-sorted $sense
}

#
# Remove the SiteName for the supplied source, <i>src</i>, from the Sitebox.
#
VatUI instproc unregister src {
	$self instvar sitebox_ src_name_ rank_
	destroy_rtp_stats $src
	if [info exists src_name_($src)] {
		$rank_ clear $src_name_($src)
		$sitebox_ remove $src_name_($src)
		unset src_name_($src)
	}
}

#
# Delete the statistics associated with the source, <i>src</i>.
#
VatUI instproc deactivate src {
	$self instvar src_name_
	$src_name_($src) destroy_decoder_stats
	$src handler ""
}

#
# Called from our AudioAgent base class the first time
# a source sends data packets.  AudioAgent::activate creates
# the decoder; we do additional ui specific initialization here.
#
VatUI instproc activate src {
# FIXME this only sets lecture-mode when a new source arrives...
	set decoder [$src handler]

	# If the decoder does not exist, or is Null, then display
	# an error message.
	if {$decoder == "" || [regexp Null [$decoder info class]]} then {
		new ErrorWindow "Sorry, cannot decode this type of audio."
	}

	$self instvar controlMenu_
	$decoder lecture-mode [$controlMenu_ query lectureMode]
}

proc dummy args ""

#
# Create a SiteName for the provided source, <i>src</i>, and begin monitoring their activity.
#
VatUI public trigger_media src {
	$self instvar rank_ src_name_ id_
	if ![info exists src_name_($src)] {
		$self create_src_name $src
	}
	$src_name_($src) highlight 1
	$rank_ touch $src_name_($src)

	if { ![$src mute] && ![winfo ismapped .] } {
		mark_icon [$self get_option iconMark]
	}
	set id_ [after 500 "$self monitor_talk_spurt $src"]

	#
	# if we don't have the audio, request.
	# (but don't demand it since this happens on
	#  network input not user intervention)
	#
	#FIXME does this belong in AudioAgent?
	#
	$self instvar audioPanel_
	$audioPanel_ action
}

#
# Every 1/2 second, check how recently the source, <i>src</i> has sent
# data.  If the source is active, keep control of the audio device, else
# unhilight their name.
#
VatUI private monitor_talk_spurt src {
	$self instvar agent_ audioPanel_ src_name_ id_
	if [info exists src_name_($src)] {
		set delta [expr [$agent_ ntp_time] - [$src last-data]]
		#FIXME delta is in ntp time units.  (65536 Hz)
		if { $delta > 20000 } {
			$src_name_($src) highlight 0
			$src enable_trigger
		} else {
			$audioPanel_ action
			set id_ [after 500 "$self monitor_talk_spurt $src"]
		}
	}
}

#
VatUI instproc clean_timers { } {
	$self instvar audioPanel_

	$audioPanel_ cancel_timer
	$self cancel_talk_monitor
}

#
# Cancels monitor_talk_spurt.
#
VatUI instproc cancel_talk_monitor { } {
        $self instvar id_
        if [info exists id_] {
                after cancel $id_
                unset id_
        }
}

#
# Update the sdes information for the provided source, <i>src</i>.
#
VatUI instproc trigger_sdes src {
	$self instvar src_name_
	global src_info src_nickname
	if ![info exists src_name_($src)] {
		#
		# create_src_name will call us back (with the name set)
		# so just return here
		#
		$self create_src_name $src
		return
	}
	#
	# Figure out best presentation from available information.
	#
	set name [$src sdes name]
	set cname [$src sdes cname]
	set addr [$src addr]
	if { $name == "" } {
		if { $cname == "" } {
			set src_nickname($src) $addr
			set info $addr/[$src format_name]

		} else {
			set src_nickname($src) $cname
			set info "$addr/[$src format_name]"
		}
	} elseif [cname_redundant $name $cname] {
		set src_nickname($src) $name
		set info $addr/[$src format_name]
	} else {
		set src_nickname($src) $name
		set info $cname/[$src format_name]
	}
	set src_info($src) $cname/[$src format_name]

	set msg [$src sdes text]
	if { $msg != "" } {
		set info $msg
	}
	set src_info($src) $info

	#
	# only call change_name when name really changes
	# all this does is change the name in the on-screen site display
	#
	if { [$src_name_($src) text] != $src_nickname($src) } {
		$src_name_($src) text $src_nickname($src)
	}
}

#
VatUI instproc trigger_idle src {
	$self instvar src_name_
	if [info exists src_name_($src)] {
		$src_name_($src) disable [$src lost]
	}
}

#FIXME
VatUI instproc trigger_format src {
	$self instvar agent_
	$agent_ deactivate $src
	$agent_ activate $src
}

#
# Set the title of the window and the icon for the ui to the provided
# <i>prefix</i> <i>name</i> pair.
#
VatUI instproc window-title { prefix name } {
	$self instvar name_ prefix_
	set name_ $name
	set prefix_ $prefix
	wm iconname . "$prefix_ $name_"
	wm title . "$prefix_ $name_"
#	proc mark_icon mark "$self mark-icon \$mark"
}

