# ui-ctrlmenu.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vat/ui-ctrlmenu.tcl,v 1.10 2002/02/03 04:30:33 lim Exp $


import TextEntry GlobalStatWindow KeyEditor Configuration TopLevelWindow

#
# A control menu to control the various elements of
# the audio subsystems.
#
Class AudioControlMenu -superclass TopLevelWindow -configuration {
	defaultPriority 100
	mikeMute true
	lectureMode false
	meterEnable true
	mikeAGC false
	speakerAGC false
	mikeAGCLevel 0
	speakerAGCLevel 0
	autoRaise true
	externalEchoCancel false
	silenceThresh 20
	keepSites false
	sortSites true
	muteNewSites false
	speakerMode NetMutesMike
	jackMode FullDuplex
	lineoutMode NetMutesMike
	lineout2Mode NetMutesMike
	audioFormat PCM2
}


#
# Creates a toplevel window at ".menu".
#
AudioControlMenu instproc init { agent ui panel } {
	$self add_default ctrlTitleFont [$self get_option helv12b]
	$self add_default ctrlFont [$self get_option helv10b]
	$self add_default noAudioFont [$self get_option helv10o]
	$self next .menu
	$self instvar ui_ agent_ panel_
	set agent_ $agent
	set ui_ $ui
	set panel_ $panel

	$self setup_tkvars

	$self tkvar audioFormat silenceThresh
	if { $audioFormat != "" } {
		if { [$agent select_format [string range $audioFormat 0 2] \
				[string range $audioFormat 3 4]] < 0 } {
			puts stderr "[$self get_option appname]: unknown audio format: $audioFormat"
			exit 1
		}
	}
	if { $silenceThresh != "" } {
		$agent set_silence_thresh $silenceThresh
	}

	$self enable_meters

	$self tkvar recvOnly
	$ui set_recv_only $recvOnly
	if { $recvOnly || [$self yesno mikeMute] } {
		$panel_ ptt-release
	}
}

#
AudioControlMenu instproc test_tone type {
	$self instvar agent_ panel_
	$panel_ action
	$agent_ audio_test $type
}

#
AudioControlMenu instproc mk.tests { w } {
	label $w.label -text "Audio Tests" -font [$self get_option ctrlTitleFont]
	frame $w.frame -borderwidth 2 -relief sunken
	frame $w.frame.p1
	frame $w.frame.p2

	set f [$self get_option ctrlFont]
	set p $w.frame.p1
	$self instvar agent_
	radiobutton $p.none -text none -relief flat \
		-command "$self test_tone none" \
		-anchor w -variable [$self tkvarname audioTest] \
		-font $f -value none
	$p.none select
	pack $p.none -fill x
	$self instvar agent_
	if ![$agent_ is_halfduplex] {
		radiobutton $p.loop -text "loopback" -relief flat \
			-command "$self test_tone loopback" -value loopback \
			-anchor w -variable [$self tkvarname audioTest] \
			-font $f
		pack $p.loop -fill x
	}
	set p $w.frame.p2
	radiobutton $p.t6 -text "-6dBm tone" -relief flat -value t6 \
		-command "$self test_tone low" -anchor w \
		-variable [$self tkvarname audioTest] -font $f
	radiobutton $p.t0 -text "0dBm tone" -relief flat -value t0 \
		-command "$self test_tone med" -anchor w \
		-variable [$self tkvarname audioTest] -font $f
	radiobutton $p.tmax -text "max tone" -relief flat -value tmax \
		-command "$self test_tone max" -anchor w \
		-variable [$self tkvarname audioTest] -font $f
	pack $p.t6 $p.t0 $p.tmax -expand 1 -fill x

	pack $w.frame.p1 -side left -anchor center
	pack $w.frame.p2 -side left -expand 1 -fill both

	pack $w.label -fill x
	pack $w.frame -fill both -expand 1

	$self tkvar audioTest
	set audioTest none
}

#
AudioControlMenu instproc enable_meters {} {
	$self instvar panel_
	$self tkvar meterEnable
	$panel_ enable_meters $meterEnable
}

#
AudioControlMenu instproc set-pri p {
	$self instvar ui_ panel_
	#FIXME
	[$panel_ set arbiter_] set-pri $p
}

#
AudioControlMenu instproc pri_accept { w pri } {
	$self tkvar audioPri
	if { $audioPri == 0 } {
		$self set-pri $pri
	}
	return 0
}

#
AudioControlMenu instproc mk.pri { w } {
	label $w.label -text "Priority" -font [$self get_option ctrlTitleFont]
	frame $w.frame -borderwidth 2 -relief sunken
	set f [$self get_option ctrlFont]
	set p $w.frame.inset
	frame $p -borderwidth 0
	pack $p -anchor c
	radiobutton $p.high -text "high (200)" -relief flat -value 200 \
		-variable [$self tkvarname audioPri] \
		-command "$self set-pri 200" -font $f
	radiobutton $p.med -text "med (100)" -relief flat -value 100 \
		-variable [$self tkvarname audioPri] \
		-command "$self set-pri 100" -font $f
	radiobutton $p.low -text "low (10)" -relief flat -value 10 \
		-variable [$self tkvarname audioPri] \
		-command "$self set-pri 10" -font $f
	frame $p.f
	radiobutton $p.f.rb -text "" -relief flat -value 0 \
		-command "$self set-pri \[$p.f.entry get\]" \
		-variable [$self tkvarname audioPri] -font $f

	new TextEntry "$self pri_accept" $p.f.entry ""
	#FIXME
	$p.f.entry configure -width 4

	pack $p.f.rb $p.f.entry -side left
	pack $p.f.entry -side left -expand 1 -fill x

	set pri [$self get_option defaultPriority]
	if { $pri == 10 } {
		$p.low select
	} elseif { $pri == 100 } {
		$p.med select
	} elseif { $pri == 200 } {
		$p.high select
	} else {
		$p.f.rb select
	}
	$p.f.entry insert 0 $pri
	set entryTab($p.f.entry:value) $pri

	pack $p.high $p.med $p.low $p.f -expand 1 -fill x
	pack $w.label $w.frame -expand 1 -fill x
}

#
AudioControlMenu instproc mk.oradio { w } {
	$self set duplex_panel_ $w
	set f [$self get_option ctrlFont]
	$self instvar agent_
	set labels [$agent_ get_output_ports]
	set i 0
	set n [llength $labels]
	while { $i < $n } {
		set p $w.p$i
		frame $p
		set port [lindex $labels $i]
		set label $port
		global omode$i
		if { $label == "speaker" } { set label "spkr" }
		label $p.label -text $label -font $f
		radiobutton $p.mmn -text "" -relief flat -value MikeMutesNet \
			-command "$agent_ set_speakerphone $port mikemutesnet"\
			-variable omode$i -font $f
		radiobutton $p.nmm -text "" -relief flat -value NetMutesMike \
			-command "$agent_ set_speakerphone $port netmutesmike"\
			-variable omode$i -font $f
		radiobutton $p.fd -text "" -relief flat -value FullDuplex \
			-command "$agent_ set_speakerphone $port fullduplex" \
			-variable omode$i -font $f
		pack $p.label $p.mmn $p.nmm $p.fd
		if { [$self yesno externalEchoCancel] } {
			radiobutton $p.ec -text "" -relief flat \
			-value EchoCancel \
			-command "$agent_ set_speakerphone $port echocancel" \
			-variable omode$i -font $f
			pack $p.ec
		}
		pack $p -side left -anchor w
		set omode$i [$self get_option $port\Mode]
		eval "$agent_ set_speakerphone $port \$omode$i"

		incr i
	}
	frame $w.label
	label $w.label.blank -text "" -font $f
	label $w.label.mmn -text "Mike mutes net" -font $f
	label $w.label.nmm -text "Net mutes mike" -font $f
	label $w.label.fd -text "Full duplex" -font $f
	pack $w.label.blank $w.label.mmn $w.label.nmm $w.label.fd -anchor w
	if { [$self yesno externalEchoCancel] } {
		label $w.label.ec -text "Ext. Echo Cancel" -font $f
		pack $w.label.ec -anchor w
	}
	pack $w.label -side left -anchor w -fill x
}


AudioControlMenu instproc update_duplex { } {
	$self instvar duplex_panel_ agent_
	if ![$agent_ is_halfduplex] {
		if [info exists duplex_panel_] {
			catch {pack $duplex_panel_ \
					-before [winfo parent \
					$duplex_panel_].buttons \
					-anchor c -pady 4 -fill x -padx 5}
		}

		foreach port [$agent_ get_output_ports] {
			set omode [$self get_option $port\Mode]
			$agent_ set_speakerphone $port $omode
		}
	} else {
		if [info exists duplex_panel_] {
			catch {pack forget $duplex_panel_}
		}
		foreach port [$agent_ get_output_ports] {
			$agent_ set_speakerphone $port mikemutesnet
		}
	}
}


#
# place
# global tcl variables.  Called
# after command line options have been parsed.
#
AudioControlMenu instproc setup_tkvars {} {
	foreach r { autoRaise keepSites sortSites muteNewSites mikeAGC \
			speakerAGC meterEnable lectureMode recvOnly } {
		$self tkvar $r
		set $r [$self yesno $r]
	}
	foreach r { audioFormat iconPrefix silenceThresh } {
		$self tkvar $r
		set $r [$self get_option $r]
	}
	set audioFormat [string toupper $audioFormat]
}

#
# Query one of the variables controlled by tk widgets.
#
AudioControlMenu instproc query which {
	$self tkvar $which
	return [set $which]
}

#
AudioControlMenu instproc set_silence_thresh {} {
	$self instvar agent_
	$self tkvar silenceSuppressor silenceThresh
	if $silenceSuppressor {
		$agent_ set_silence_thresh $silenceThresh
	} else {
		$agent_ set_silence_thresh 0
	}
}

#
AudioControlMenu instproc mk.obuttons { w } {

	set f [$self get_option ctrlFont]
	frame $w.p0 -borderwidth 0
	frame $w.p1 -borderwidth 0
	pack $w.p0 $w.p1 -side left -fill x -anchor n

	set p $w.p0
	checkbutton $p.ar -text "Autoraise" -relief flat -font $f \
		-variable [$self tkvarname autoRaise]

	checkbutton $p.dm -text "Disable Meters" -relief flat -font $f \
		-command "$self enable_meters" \
		-variable [$self tkvarname meterEnable] \
		-onvalue 0 -offvalue 1

	checkbutton $p.nss -text "Suppress Silence" -relief flat -font $f \
		-command "$self set_silence_thresh" \
		-variable [$self tkvarname silenceSuppressor]
	$self tkvar silenceSuppressor
	$self instvar silenceSuppressorButton_
	set silenceSuppressor 1
	set silenceSuppressorButton_ $p.nss

	pack $p.ar $p.dm $p.nss -expand 1 -fill x

	set p $w.p1
	$self tkvar keepSites sortSites
	checkbutton $p.mns -text "Mute New Sites" -relief flat -font $f \
		-variable [$self tkvarname muteNewSites]

	$self instvar agent_
	checkbutton $p.kas -text "Keep All Sites" -relief flat -font $f \
	    -command "$agent_ keep-sites \[set [$self tkvarname keepSites]]" \
		-variable [$self tkvarname keepSites]
	$agent_ keep-sites $keepSites
	$agent_ site-drop-time [$agent_ get_option siteDropTime]

	$self instvar ui_
	checkbutton $p.kss -text "Keep Sites Sorted" -relief flat -font $f \
	    -command "$ui_ keep-sorted \[set [$self tkvarname sortSites]]" \
		-variable [$self tkvarname sortSites]
	$ui_ keep-sorted $sortSites

	pack $p.mns $p.kas $p.kss -expand 1 -fill x
}

proc setAGC { w which level } {
	$w.label configure -text "$level dB"
	controller agc-$which $level
}

proc enableAGC { w which } {
	global doAGC
	if $doAGC($which) {
		controller agc-$which [$w.scale get]
		controller agc-$which-enable 1
		$w.scale configure -state normal
	} else {
		controller agc-$which-enable 0
		$w.scale configure -state disabled
	}
}

proc oneagc { w which label } {
	set f [$self get_option ctrlFont]
	checkbutton $w.button -text $label -relief flat -font $f \
		-command "enableAGC $w $which" -variable doAGC($which)
	scale $w.scale -orient horizontal \
			-showvalue 0 \
			-from -10 -to 10 \
			-command "setAGC $w $which" \
			-relief groove -borderwidth 2 -width 10 \
			-state disabled

	label  $w.label -text "0 dB" -width 5 -font $f
	pack $w.button $w.scale $w.label -side left
	pack $w.scale -expand 1 -fill x -pady 3

	global AGCbutton
	set AGCbutton($which) $w.button
}

#
AudioControlMenu instproc mk.agc { w } {
	label $w.label -text "Automatic Gain Control" -font [$self get_option ctrlTitleFont]
	frame $w.frame -borderwidth 2 -relief sunken

	frame $w.frame.spkr -borderwidth 0
	frame $w.frame.mike -borderwidth 0

	oneagc $w.frame.spkr output Spkr
	$w.frame.spkr.scale set [$self get_option speakerAGCLevel]
	oneagc $w.frame.mike input Mike
	$w.frame.mike.scale set [$self get_option mikeAGCLevel]

	pack $w.frame.spkr $w.frame.mike -fill x
	pack $w.label $w.frame -expand 1 -fill x
	pack $w.frame -padx 6
}

#
AudioControlMenu instproc set_ssthresh { w level } {
	$self tkvar silenceThresh silenceSuppressor
	$self instvar silenceSuppressorButton_
	$w.label configure -text $level
	set silenceThresh $level
	$self set_silence_thresh
	if !$silenceSuppressor {
		$silenceSuppressorButton_ invoke
	}
}

#
AudioControlMenu instproc mk.ssthresh w {
	set f [$self get_option ctrlFont]

	$self tkvar silenceThresh
	label $w.button -text "Silence Thresh: " -relief flat -font $f
	scale $w.scale -orient horizontal \
			-showvalue 0 \
			-from 10 -to 60 \
			-command "$self set_ssthresh $w" \
			-relief groove -borderwidth 2 -width 10
	$w.scale set $silenceThresh
	label  $w.label -text $silenceThresh -width 3 -font $f
	pack $w.button $w.scale $w.label -side left
	pack $w.scale -expand 1 -fill x -pady 3
}

#
AudioControlMenu instproc mk.omode { w } {
	label $w.label -text "Output Mode" -font [$self get_option ctrlTitleFont]

	frame $w.frame -borderwidth 2 -relief sunken
	frame $w.frame.radios -borderwidth 0
	frame $w.frame.buttons -borderwidth 0

	$self mk.oradio $w.frame.radios

	$self mk.obuttons $w.frame.buttons
	frame $w.frame.ssthresh
	# mk.ssthresh $w.frame.ssthresh
	#pack $w.frame.radios $w.frame.buttons $w.frame.ssthresh \
	#	-anchor c -pady 4
	pack $w.frame.radios $w.frame.buttons \
		-anchor c -pady 4 -fill x -padx 5
	pack $w.label $w.frame -expand 1 -fill x

	$self instvar agent_
	if [$agent_ is_halfduplex] {
		$self update_duplex
	}
}

#
AudioControlMenu instproc mk.me w {
	set f [$self get_option ctrlFont]
	frame $w.mode -borderwidth 2 -relief sunken
	frame $w.mode.inset -borderwidth 0
	set p $w.mode.inset
	label $p.title -text "Tx Mode" -font $f
	pack $p.title -side top -anchor n -expand 1 -fill both
	$self instvar ui_
	checkbutton $p.lec -text "Lecture" \
		-command "$ui_ set_lecture_mode \
			\[set [$self tkvarname lectureMode]]" \
		-variable [$self tkvarname lectureMode] -font $f

	checkbutton $p.ro -text "RecvOnly" \
		-command "$ui_ set_recv_only \
			\[set [$self tkvarname recvOnly]]" \
		-variable [$self tkvarname recvOnly] -font $f

	pack $p.lec $p.ro -fill x
	pack $p -anchor n
	pack $p -side left -expand 1 -fill x

	frame $w.fmt -borderwidth 2 -relief sunken
	label $w.fmt.title -text "Output Format" -font $f
	pack $w.fmt.title -side top
	frame $w.fmt.p1
	set p $w.fmt.p1
	$self instvar agent_
	radiobutton $p.pcm -text PCM -font $f -value PCM \
		-command "$agent_ select_format PCM 1" \
		-variable [$self tkvarname audioFormat]
	radiobutton $p.pcm2 -text PCM2 -font $f -value PCM2 \
		-command "$agent_ select_format PCM 2" \
		-variable [$self tkvarname audioFormat]
	radiobutton $p.pcm4 -text PCM4 -font $f -value PCM4 \
		-command "$agent_ select_format PCM 4" \
		-variable [$self tkvarname audioFormat]
	pack $p.pcm $p.pcm2 $p.pcm4 -expand 1 -fill x

	frame $w.fmt.p2
	set p $w.fmt.p2
	radiobutton $p.dvi -text DVI -font $f -value DVI \
		-command "$agent_ select_format ADPCM 1" \
		-variable [$self tkvarname audioFormat]
	radiobutton $p.dvi2 -text DVI2 -font $f -value DVI2 \
		-command "$agent_ select_format ADPCM 2" \
		-variable [$self tkvarname audioFormat]
	radiobutton $p.dvi4 -text DVI4 -font $f -value DVI4 \
		-command "$agent_ select_format ADPCM 4" \
		-variable [$self tkvarname audioFormat]
	pack $p.dvi $p.dvi2 $p.dvi4 -expand 1 -fill x

	frame $w.fmt.p3
	set p $w.fmt.p3
	radiobutton $p.gsm -text GSM -font $f -value GSM \
		-command "$agent_ select_format GSM 4" \
		-variable [$self tkvarname audioFormat]
	radiobutton $p.lpc4 -text LPC4 -font $f -value LPC4 \
		-command "$agent_ select_format LPC 4" \
		-variable [$self tkvarname audioFormat]
	pack $p.gsm $p.lpc4 -expand 1 -fill x
	pack $w.fmt.p1 $w.fmt.p2 $w.fmt.p3 -side left
	pack $w.mode -side left -expand 1 -fill both
	pack $w.fmt -side left
	set ttl [$self get_option defaultTTL]
	$self tkvar audioFormat
	if {$ttl > 160} {
		$w.fmt.p1.pcm configure -state disabled
		if {$audioFormat  == "PCM"} {
			set audioFormat PCM2
		}
		if {$ttl > 192} {
			$w.fmt.p1.pcm2 configure -state disabled
			$w.fmt.p1.pcm4 configure -state disabled
			if {[regexp -nocase pcm $audioFormat]} {
				set audioFormat DVI2
			}
			if {$ttl > 200} {
				$w.fmt.p2.dvi configure -state disabled
				$w.fmt.p2.dvi2 configure -state disabled
				$w.fmt.p2.dvi4 configure -state disabled
				if {[regexp -nocase dvi $audioFormat]} {
					set audioFormat GSM
				}
			}
		}
	}
}

#
AudioControlMenu instproc new_hostspec {} {
	$self instvar agent_ addrlabel_
	if ![info exists addrlabel_] {
		return
	}
	set addr [$agent_ session-addr]
	set port [$agent_ session-port]
	set ttl [$agent_ session-ttl]
	$addrlabel_ configure -text \
		"Dest: $addr  Port: $port  TTL: $ttl"
}

#
AudioControlMenu instproc mk.info { w } {
	$self instvar agent_ addrlabel_
	set addr [$agent_ session-addr]
	set port [$agent_ session-port]
	set ttl [$agent_ session-ttl]
	label $w.label -font [$self get_option ctrlFont] -text \
		"Dest: $addr  Port: $port  TTL: $ttl"
	set addrlabel_ $w.label
	pack $w.label -expand 1 -fill x
}

#
# Creates a global window
#
AudioControlMenu instproc create-global-window {} {
	$self instvar src_ global_win_
	if [info exists global_win_] {
		$self delete-global-window
	} else {
		set global_win_ [new GlobalStatWindow .gstat \
					"RTP Statistics" \
					"RTP Statistics" \
					"$self get-global-stats" \
					"$self delete-global-window"]
	}
}

#
AudioControlMenu instproc delete-global-window {} {
	$self instvar global_win_
	delete $global_win_
	unset global_win_
}

#
AudioControlMenu instproc get-global-stats {} {
	return "Foo 1"
}


#
AudioControlMenu instproc mk.entries { w } {
#	global sessionKey
#	set sessionKey [$self get_option sessionKey]

	frame $w.name
	label $w.name.label -text "Name: " -font [$self get_option ctrlFont] -anchor e -width 6
	new TextEntry "$self update_name" $w.name.entry \
	    [$self get_option rtpName]
	pack $w.name.label -side left
	pack $w.name.entry -side left -expand 1 -fill x -pady 2

	frame $w.msg
	label $w.msg.label -text "Note: " -font [$self get_option ctrlFont] -anchor e -width 6
	new TextEntry "$self update_note" $w.msg.entry ""
	pack $w.msg.label -side left
	pack $w.msg.entry -side left -expand 1 -fill x -pady 2

	#
	# Create the entry widget for editing the session's
	# encryption key.  The audio agent exports methods
	# (invoked by the KeyEditor) to enable/disable encryption.
	#
	$self instvar agent_
	new KeyEditor $w $agent_

	pack $w.name $w.msg $w.key -expand 1 -fill x

	frame $w.b

	# for now (i.e. until GlobalStatWindow is further implemented)
        button $w.b.stats -text "Global Stats" -borderwidth 2 \
                -anchor c -font [$self get_option ctrlFont] \
		-command "$self create-global-window"
	pack $w.b.stats -side left -padx 4 -pady 2 -anchor c
	$w.b.stats configure -state disabled

	pack $w.b -pady 2 -anchor c
}

#
AudioControlMenu instproc update_name name {
	if { $name != ""} {
		$self instvar agent_
		$agent_ set_local_sdes name $name
		return 0
	}
	return -1
}

#
AudioControlMenu instproc update_note note {
	$self instvar agent_
	$agent_ set_local_sdes note $note
	return 0
}

#
AudioControlMenu instproc mk.net { w } {
	label $w.label -text "Network" -font [$self get_option ctrlTitleFont]
	frame $w.frame -borderwidth 0
	frame $w.frame.me -borderwidth 0
	frame $w.frame.ie -borderwidth 2 -relief sunken
	frame $w.frame.ie.info -borderwidth 0
	frame $w.frame.ie.entries -borderwidth 0

	$self mk.me $w.frame.me
	$self mk.info $w.frame.ie.info
	$self mk.entries $w.frame.ie.entries

	pack $w.label $w.frame -expand 1 -fill x
	pack $w.frame -padx 6

	pack $w.frame.ie.info $w.frame.ie.entries -expand 1 -fill x
	pack $w.frame.me $w.frame.ie -expand 1 -fill x
}

#
# Build the menu panel.  Called from toggle_window,
# the first time the Menu button is hit.
#
AudioControlMenu instproc build w {
	$self create-window $w "Audio Settings"
#	wm withdraw $w
	bind $w <Enter> "focus $w"
	frame $w.tp
	frame $w.tp.tests
	frame $w.tp.pri
	frame $w.omode
	#FIXMEframe $w.agc
	frame $w.net

	$self mk.tests $w.tp.tests
	$self mk.pri $w.tp.pri
	$self mk.omode $w.omode
	#FIXME NOT YET mk.agc $w.agc
	$self mk.net $w.net
	button $w.ok -text " Dismiss " -borderwidth 2 -relief raised \
		-command "$self toggle" -font [$self get_option ctrlTitleFont]
	frame $w.pad -borderwidth 0 -height 6

	pack $w.tp.tests -side left -expand 1 -fill both -padx 2
	pack $w.tp.pri -side left -expand 1 -fill x -padx 2
	#FIXME pack $w.tp $w.omode $w.agc $w.net -expand 1 -fill x
	pack $w.tp $w.omode $w.net -expand 1 -fill x
	pack $w.ok -pady 6 -anchor c
	pack $w.tp -padx 4
	pack $w.omode -padx 6

        wm protocol $w WM_DELETE_WINDOW "$self toggle"
}

