# application-vat.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vat/application-vat.tcl,v 1.60 2002/02/03 04:30:33 lim Exp $


import RTPApplication AddressBlock AudioAgent VatUI \
	FontInitializer WidgetResourceInitializer CoordinationBus
#
# The base class for the vat application.  Parses the command line
# arguments, creates all the necessary agents and objects, configures
# them, and splices them together.
#
Class VatApplication -superclass RTPApplication

#
# The vat application constructor.  Parse the command line
# options in argument <i>argv</i> and build the app.
# Creates a frame using the provided <i>widgetPath</i> and pack the vat ui in it.
#
VatApplication instproc init { widgetPath argv } {
	$self next vat
	set o [$self options]
	$self init_args $o

	# Search for some good fonts for the user interface and intial
	# the configuration options accordingly.
	new FontInitializer $o
	option add *Font [$o get_option helv14b] startupFile
	option add *Radiobutton.font [$o get_option helv12b] 100

	$self init_resources $o

	$o load_preferences "rtp vat"
	set argv [$o parse_args $argv]

	# Source the user's hook file if it exists. The function
	# user_hook, which may be defined in this file, will be
	# called at the end of init.
	if {[$o get_option userhookFile] != ""} {
		if {[file isfile [$o get_option userhookFile]] && \
			[file readable [$o get_option userhookFile]]} {
			source [$o get_option userhookFile]
		} else {
			puts stderr "Unable to source \"[$o get_option userhookFile]\". Not a file or not readable."
		}
	}

	set spec [$self check_hostspec $argv [$self get_option megaAudioSession]]
	$self check_rtp_sdes

	$self instvar ui_ agent_

	set agent_ [new AudioAgent $self $spec]

	$self init_confbus

	set ui_ [$self init_ui $widgetPath $spec]

	$self user_hook

	# vat can sometimes take a long time to process events at start up.
	# To avoid displaying a blank window for a long time, we'll update the
	# window now.
	update idletasks
}

#
# Creates a frame using the provided <i>widgetPath</i> and pack the vat ui in it.
#
VatApplication instproc init_ui { widgetPath spec } {
	$self instvar agent_ glob_chan_

	frame $widgetPath
	set ui [new VatUI $widgetPath $glob_chan_ $agent_ "$self exit" $spec]
	pack $widgetPath -expand 1 -fill both

	return $ui
}

#
VatApplication instproc reset { ab } {
	$self instvar ui_
	$ui_ reset
}

#
VatApplication instproc exit {} {
    $self instvar ui_ agent_ local_chan_ glob_chan_
    delete $ui_
    $agent_ release
    $agent_ shutdown
    delete $agent_
    delete $local_chan_
    delete $glob_chan_
    exit
}

#
VatApplication instproc init_args o {
	$o register_option -B maxbw
	$o register_option -C conferenceName
	$o register_option -D device
	$o register_option -f audioFormat
	$o register_option -F maxfps
	$o register_option -I confBusChannel
	$o register_option -K sessionKey
	$o register_option -M colorFile
	$o register_option -m mtu
	$o register_option -o outfile
	$o register_option -t defaultTTL
	$o register_option -T softJPEGthresh
	$o register_option -u userhookFile
	$o register_option -V visual
	# dummy option for compatibility
	$o register_boolean_option -r compat
	$o register_option -confid confid
	$o register_option -loopback loopback
	$o register_list_option -map rtpMap

	# MeGa resources
	$o register_option -rport megaRecvAudioPort
	$o register_option -ofmt megaAudioFormat
	$o register_option -usemega megaAudioSession
	$o register_option -megactrl megaAudioCtrl
	$o register_option -sspec audioSessionSpec
	$o register_option -maxsbw maxAudioSessionBW
	$o register_option -sbw audioSessionBW
	$o register_option -sloc audioServiceLocation

	# cues option
	$o register_boolean_option -useCues useCues

        # lame options
        $o register_option -lb bitRate
        $o register_option -ls sampleRate
}

#
# Initialize the configuration data base with all of the default
# options assumed by vat.  These can be overridden.
#
VatApplication instproc init_resources o {
	new WidgetResourceInitializer

	# used by TopLevelWindow, AudioControlMenu, and VatApplication
	$o add_default iconPrefix vat:

	# used when creating new CoordinationBus; get and set by AddressBlock
	$o add_default defaultTTL 16

	# used by c++ code
	$o add_default afDevice -1
	$o add_default afBlocks 2
	$o add_default afSoftOuputGain 0
	$o add_default afSoftInputGain 0
	$o add_default audioFileName /dev/audio

	# used by AudioControlMenu; set by AddressBlock
	$o add_default audioFormat PCM2

	# WAS used by init_confbus
	$o add_default confBusChannel 0

        # lame defaults
        $o add_default sampleRate 44100
        $o add_default bitRate 128
}

#
# Create a global bus for communication between tools
# on different machines, and a local bus for tools on
# the same machine.
#
VatApplication instproc init_confbus {} {
	# set channel [$self get_option confBusChannel]
	# $self instvar cb_ agent_
	# if { $channel != 0 } {
	# 	set cb_ [new CoordinationBus -channel $channel]
	# 	$agent_ attach_coordbus $cb_
	# } else {
	# 	set cb_ ""
	# }

        $self instvar agent_ local_chan_ glob_chan_
        set local_chan_ [new CoordinationBus -channel 2]
        $agent_ attach_local_channel $local_chan_

        set ttl [$self get_option defaultTTL]
        set glob_chan_ [new CoordinationBus -channel 3 -ttl $ttl]
        $agent_ attach_global_channel $glob_chan_
}
