# server-rtsp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import TCP SessionCatalog Application RTSPWorker SDPParser

#Class RTSPServerManager -superclass TCP/Server

#RTSPServerManager instproc create_channel chan {
#	return [new RTSPServer $chan]
#}

#RTSPServerManager public init port {
#	$self next
#	$self open $port
#}



# Implements the functionality of an archive server which uses RTSP for communication with the client.  Currently, this code is part of the arms application.  We are concentrating on developing a soft state protocol with RTSP's functionality (SSAC) so this code will not be under development.
# Status: Alpha
# Needs a lot of cleaning up, error trapping.  I'm suspicious of the efficacy of teardown.

#<FIXME should not be a subclass of application!>
Class RTSPServer -superclass { Application TCP }

global response_code_
global version

set response_code_(200) "OK"
set response_code_(400) "Bad request"
set response_code_(403) "Forbidden"
set response_code_(404) "Not found"
set response_code_(405) "Method Not Allowed"
set response_code_(451) "Parameter not understood"
set response_code_(500) "Internal server error"

set version "RTSP/1.0"


#FIXME "self next player"?
RTSPServer instproc init { } {
	puts "Making new server"
	$self next player
	puts "Made new server"
	RTSPServer set instance_ $self
	$self set buffer_ ""
}


RTSPServer instproc open chan {
	#puts "Making new server"
	#$self next player
	#puts "Made new server"
	#RTSPServer set instance_ $self
	#$self set buffer_ ""

	$self next $chan

	#I don't think this is necessary, can remove from_
	set peer [fconfigure $chan -peername]
puts stderr "PEER $peer"
	$self set from_ [lindex $peer 0]

}

#FIXME
RTSPServer instproc instance {} {
	return [$self set instance_]
}

#
# Called from TCP module when we receive data on our socket, which
# consists of rtsp commands from the server that we have connected to.
# We receive the data a line at a time.
#
RTSPServer instproc recv s {
	$self instvar buffer_ parser_
	set buffer_ "$buffer_\n$s"
	#
	# Check for blank line then hand to parser.
	#
	if { [string trim $s] == "" } {
		set m [string trim $buffer_]
		set buffer_ ""
		if { $m == "" } {
			return
		}

		#
		# send reponse followed by a blank line
		#
		set response [$self recv_message $m]
		$self send "$response\n"
	}
}

RTSPServer instproc recv_message msg {

	$self instvar response_

	if [catch {$self parse $msg} error] {
		set response_(code) 400
		set response_(tokens) {}
		puts "Error parsing"
	}

	if [catch {$self state-machine $msg} error] {
		set response_(code) 500
		set response_(tokens) {}
		puts "Server State-machine error"
	}

	if {! [info exists response_(tokens)] } {
		set response_(tokens) {}
	}
	if {! [info exists response_(body)] } {
		set response_(body) ""
	}
	set resp [$self build_response $response_(code) $response_(tokens) $response_(body)]
	set response_(tokens) {}
	set response_(body) ""

	return $resp
}

RTSPServer instproc build_response {code extras body} {
	global version response_code_
	$self instvar params_

	set myresponse "$version $code $response_code_($code)"
	if [info exists params_(CSeq)] {
		set myresponse "$myresponse\nCSeq: $params_(CSeq)"
	}
	foreach token $extras {
		set myresponse "$myresponse\n$token: $params_($token)"
	}
	if {$body != ""} {
		set myresponse "$myresponse\n$body\n\n"
	} else {
		set myresponse "$myresponse\n\n"
	}
	#puts "----START RESPONSE----\n$myresponse\n----END RESPONSE----"

	return $myresponse
}



RTSPServer instproc parse {msg} {
	$self instvar params_

	if [info exists params_] {
		unset params_
	}

	set lines [split $msg "\n"]
	set request_line [split [lindex $lines 0]]
	set params_(method) [lindex $request_line 0]
	set params_(uri) [lindex $request_line 1]
	set params_(rtsp_version) [lindex $request_line 2]

	set len [llength $lines]

	for {set n 1} {$n < $len} { incr n} {
		regexp {([a-zA-Z]+)(: )(.+)} [lindex $lines $n] all token mid rest
		set rest [string trim $rest]
		if [info exists token] {
			set params_($token) $rest
			#puts "Tokens: $token $rest"

		}
	}
}

RTSPServer instproc call-new-worker {} {
	$self instvar params_ workers_ response_ from_

	if { ! [info exists params_(Session)] } {
		set new_num [$self generate-session-id]
		set params_(Session) $new_num
		set workers_($new_num) [new RTSPWorker $new_num $from_]
		set paramlist [array get params_]
		set response_(code) [$workers_($new_num) recv $paramlist]
	} else {
		# error check here
		set param_list [array get params_]
		set response_(code) [$workers_($params_(Session)) recv $param_list]
		puts "Worker returned $response_(code)"
	}
}

RTSPServer instproc call-worker {} {
	$self instvar params_ workers_ response_

	if { ! [info exists params_(Session)] } {
		puts "No Session param"
		# error
	} else {
		# error check here
		set param_list [array get params_]
		set response_(code) [$workers_($params_(Session)) recv $param_list]
		puts "Worker returned $response_(code)"
	}

}

RTSPServer instproc state-machine {msg} {
	$self instvar params_ response_ cur_state_ workers_

	switch $params_(method) {
		OPTIONS {
			puts "OPTIONS"
			set params_(Public) "OPTIONS, PLAY, SETUP, TEARDOWN"
			set response_(code) 200
			set response_(tokens) {Public}

		}
		DESCRIBE {
			puts "DESCRIBE"
			set response_(code) 200
			set response [$self do_describe]
			if { $response_(code) != 200 } {
				set response_(tokens) {}
				return
			}
			#$self send_describe $response
			set params_(Content-Type) "application/sdp"
			set params_(Content-Length) [string length $response]
			puts "--DESCRIBE"
			set response_(tokens) {Content-Type Content-Length}
			set response_(body) $response

		}
		SETUP {
			if {[info exists params_(Session)]} {
				$self call-worker
			} else {
				$self call-new-worker
			}
			if {$response_(code) < 202} {
				set temp $params_(Session)
				puts "temp $temp"
				set cur_state_($temp) ready
				puts "ready"
				set response_(tokens) {Session Transport}
			}
			puts "Done"
		}
		TEARDOWN {
			# FIX THIS
			puts "TEARDOWN"
			delete $workers_($params_(Session))
			set cur_state_($params_(Session)) done
			#FIXME
			#$tcpobj_ reset_net
			$self shutdown
			# delete self?
		}
		PLAY {
			# Need to check for ready or playing?
			$self call-worker
			if {$response_(code) < 202} {
				set cur_state_($params_(Session)) playing
				set response_(tokens) {}
			}
		}
		PAUSE {
			# Need to check for ready or playing?
			$self call-worker
			if {$response_(code) < 202} {
				set cur_state_($params_(Session)) ready
				set response_(tokens) {}
			}
		}

	}
}

RTSPServer instproc generate-session-id {} {
	$self instvar cur_state_

	# FIX THIS to generate random id

	set num [array size cur_state_]
	return [incr num]

}

RTSPServer instproc do_teardown {} {
	$self instvar params_



}


RTSPServer instproc do_describe {} {
	$self instvar params_

	set start "max"
	set end "min"
	set response ""
	set resptail ""

	regexp {(rtsp://[a-z\.\:0-9]+)/(.+)} $params_(uri) junk junk2 filename

	$self instvar response_
	if ![info exists filename] {
		# Return not found (code 404)
		set response_(code) 404
		#response: parameter not understood
		puts "malformed url ($params_(uri)) - returning code 404"
		return
	}

	puts "$filename"

	set filename2 $filename.ctg

	if ![file readable $filename2] {
		# Return not found (code 404)
		set response_(code) 404
		#response: parameter not understood
		puts "$filename2 not readable - returning code 404"
		return
	}

	set catalog [new SessionCatalog]

	if { [catch {$catalog open $filename2} error] } {
		set response_(code) 451
		#response: parameter not understood
		puts "Couldn't open $filename2"
		return
	}
	if { [catch {$catalog read} error] } {
		set response_(code) 500
		#response: internal server error
		puts "Couldn't read $filename2"
		return
	}
	set sdp [$catalog get_sdp]
	if {$sdp != ""} {
		set p [new SDPParser]
		set announcement [$p parse $sdp]

		set response "v=[$announcement field_value v]"
		set response "$response\no=[$announcement field_value o]"
		set response "$response\ns=[$announcement field_value s]"
		set response "$response\ni=[$announcement field_value i]"


	} else {
		set response "v=0"
		set response "$response\no="
		set response "$response\ns=$filename"
		set response "$response\ni="

	}

	set response "$response\nu=$params_(uri)"
	foreach id [$catalog info streams] {
		lappend sessions([$catalog info session $id]) $id
	}
	set file [new ArchiveFile]
	foreach s [array names sessions] {
		foreach id $sessions($s) {
			set my_datafile [$catalog info datafile $id]
			set my_indexfile [$catalog info indexfile $id]
			if [catch {$file open $my_datafile} error] {
				set response_(code) 500
				#response: internal server error
				puts "Couldn't open $my_datafile"
				delete $catalog
				delete $file
				return
			}

			if [catch {$file header data_hdr} error] {
				set response_(code) 500
				#response: internal server error
				puts "Wrong header format for $my_datafile"
				delete $catalog
				delete $file
				return
			}
			$file close
			if [catch {$file open $my_indexfile} error] {
				set response_(code) 500
				#response: internal server error
				puts "Couldn't open $my_indexfile"
				delete $catalog
				delete $file
				return
			}

			if [catch {$file header index_hdr} error] {
				set response_(code) 500
				#response: internal server error
				puts "Wrong header format $my_indexfile"
				delete $catalog
				delete $file
				return
			}

			$file close


			if { $data_hdr(protocol)!=$index_hdr(protocol) } {
				set response_(code) 500
				#response: internal server error
				puts "Protocol fields do not\
						match in data and index files"
				delete $catalog
				delete $file
				return
			}

			if { $data_hdr(media)!=$index_hdr(media) } {
				set response_(code) 500

				#response:  internal server error
				puts "Media fields do not\
						match in $my_datafile and $my_indexfile"
				delete $catalog
				delete $file
				return
			}

			if { $data_hdr(cname)!=$index_hdr(cname) } {
				set response_(code) 500
				#response:  internal server error
				puts "Cname fields don't match \
						in $my_datafile and $my_indexfile"
				delete $catalog
				delete $file
				return
			}

			if { $data_hdr(name)!=$index_hdr(name) } {
				set response_(code) 500
				#response:  internal server error
				puts "Name fields don't match in \
						$my_datafile and $my_indexfile"
				delete $catalog
				delete $file
				return
			}

			#$file close

			#puts "This far"

			#Need to add a check for start=0

			if {$data_hdr(media)!="mediaboard"} {
				if {$start == "max"} {
					set start $data_hdr(start)
					set end $data_hdr(end)

				} else {

					if {$data_hdr(start) < $start} {
						set start $data_hdr(start)


					}
					if {$data_hdr(end) > $end} {
						set end $data_hdr(end)

					}

				}
			}


		}

		set resptail "$resptail\nm=$data_hdr(media) 0 RTP/AVP 0"
		set resptail "$resptail\nc=IN IP4 $params_(uri)/$s"
		#set resptail "$resptail\na=control:rtsp:$params_(uri)/$s"


	}


	set wholeresponse "$response\nt=$start $end$resptail"


	delete $catalog

	return $wholeresponse
}
