# main.tcl --
#
#       This is the main entry point for the mps tool.
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

source tcl/mps/gs.tcl

#FIXME
proc havefont args { return 1 }

#
# We want these resources to override user defaults
# (the option command's "userDefault" priority is 60)
# We do this for a consistent user inteface "look".
# Too often, people define *background and *foreground
# in their X resources, which gives bad results with tk.
#
option add *background gray80 61
option add *foreground black 61
option add *activeBackground gray95 61
option add *selectBackground gray95 61
option add *Scale.sliderForeground gray66 61
option add *Scale.activeForeground gray80 61
#option add *Scale.background gray70 61
option add *Scrollbar.foreground gray80 61
option add *Scrollbar.activeForeground gray70 61
option add *disabledForeground gray40

option add *Radiobutton.relief flat startupFile

#
# These can be overridden.
#
option add Tkgs.iconPrefix tkgs: startupFile
option add Tkgs.foundry adobe startupFile

#FIXME not fully tested
proc mapf f {
	if { ! [havefont $f] } {
		set i [string first 75 $f]
		set f [string range $f 0 [expr $i - 1]]*-*-*-*-*-*
	}
	return $f
}
set ff [option get . foundry Tkgs]
set helv10 [mapf "-$ff-helvetica-medium-r-normal--*-100-75-75-*-*-*-*"]
set helv10b [mapf "-$ff-helvetica-bold-r-normal--*-100-75-75-*-*-*-*"]
set helv10o [mapf "-$ff-helvetica-bold-o-normal--*-100-75-75-*-*-*-*"]
set helv12 [mapf "-$ff-helvetica-medium-r-normal--*-120-75-75-*-*-*-*"]
set helv12b [mapf "-$ff-helvetica-bold-r-normal--*-120-75-75-*-*-*-*"]
set helv14 [mapf "-$ff-helvetica-medium-r-normal--*-140-75-75-*-*-*-*"]
set helv14b [mapf "-$ff-helvetica-bold-r-normal--*-140-75-75-*-*-*-*"]
set times14 [mapf  "-$ff-times-medium-r-normal--*-140-75-75-*-*-*-*"]

option add *Font $helv12b startupFile
option add Tkgs.disablefont $helv10o
option add Tkgs.smallfont $helv10b
option add Tkgs.medfont $helv12b  startupFile
option add Tkgs.helpFont $times14 startupFile
option add Tkgs.entryFont $helv10 startupFile

proc smallfont {} {
    #FIXME
    return fixed
}

proc build.bar w {
	global title
	frame $w.bar
	label $w.bar.title -text "mps v[version]" -font [smallfont]\
		-background gray -borderwidth 2 -relief raised
	button $w.bar.quit -text Quit -borderwidth 2 -relief raised \
		-background gray -font [smallfont] -command "quit"
	button $w.bar.menu -text Menu -borderwidth 2 -relief raised \
		-background gray -font [smallfont] \
		-command "toggle_window .menu"
	button $w.bar.help -text Help -borderwidth 2 -relief raised \
		-background gray -font [smallfont] \
		-command "toggle_window .help"

	pack $w.bar.title -side left -fill x -expand 1
	pack $w.bar.menu $w.bar.help $w.bar.quit -side left
}

#
# Build the user-interface.
#
proc build.tk { } {
#	global prefix
#	set prefix [option get . iconPrefix Tkgs]
	#wm iconname . $prefix$conf
	#wm title . $conf

	. configure -background [option get . background Tkgs]
	#
	# emulate implicit keyboard focus
	#
	bind . <Enter> { focus %W }
	#wm focusmodel . active
	bind . <q> { quit }
	bind . <Control-c> { quit }
	bind . <Control-d> { quit }

	frame .top
        set pswin [new PostscriptWindow .top.wb]
	set gs [new GPSinterp $pswin]
	pack .top.wb -fill both -side bottom -expand 1
	pack .top -expand 1 -fill both

	#
	# Withdraw window so that user-placement is deferred
	# until after initial geometry is computed
	#
	wm withdraw .
	wm geometry . 612x792

	update idletasks
	set minwidth [winfo reqwidth .]
	set minheight [winfo reqheight .]
	#FIXME
	if { $minwidth < 200 || $minheight < 100 } {
		set minwidth 200
		set minheight 100
	}
	wm minsize . $minwidth $minheight
	wm deiconify .

	return $gs
}
if { $argc != 1 } {
	puts stderr "usage: mps file"
	exit 1
}
set psFile [open $argv r]
set psp [new DSC_Parser]
$psp set-file $psFile
set npage [$psp set npage_]
set pageNo 1
set tmpFile /tmp/mps.[pid].ps
proc nextPage {} {
	global pageNo npage tmpFile psp gs
	if { $pageNo > $npage } {
		quit
	}
	set f [open $tmpFile w]
	puts "Page $pageNo"
	# dump preamble then current page.
	# (but not for page 1, which includes preamble!)
	#FIXME need to fix this API
	if { $pageNo > 1 } {
		$psp dump 0 $f
	}
	$psp dump $pageNo $f
	close $f
	$gs render-file $tmpFile
	incr pageNo
}
proc quit {} {
	global gs
	delete $gs
	exit 0
}

set gs [build.tk]
update
$gs fork
#quit
bind all <Return> nextPage
