# application-atp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#   @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/atobj/application-atp.tcl,v 1.6 2002/02/03 04:25:26 lim Exp $


Class ATP -superclass Application

ATP instproc createLocalNam {file sess_mgr} {
        set namsrc [new DataSrc/Local/Nam $file]
        set namview [new AnmView/Nam]

        # get the config file
        set layout [new NamNetwork]
        $layout layout
        $namsrc attach_layout $layout

        # this is a temporary hack
        $namview setFontByIdx 0 "lucidasans-10" blue
        $namview setFontByIdx 1 \
                "-adobe-helvetica-bold-r-normal--12-*-*-*-*-*-*-*" \
                Brown
#
#        set lAgent [new LocalAnimatorAgent]
#        $lAgent connect $namview $namsrc

        $namsrc attach_view $namview
        $namview attach_datasrc $namsrc

        set local_rcvr [new Atobj_rcvr $sess_mgr]
        $namsrc attach_rcvr $local_rcvr
        $local_rcvr add_animation $namsrc

        # the local receiver is also the local source since it generates
        # data
        $sess_mgr set_local_src $local_rcvr

        # initialize the layout and convert it into animation objects
        $namsrc setup

        set ui [new NamUI]
        $ui attach_view $namview
        $ui attach_datasrc $namsrc

        set host [info hostname]
        wm title [$namview path] "Nam@$host"
}

ATP instproc initNet {} {
        $self instvar sess_mgr_ srm_sessn_ src_mgr_
        set sess_mgr_ [new Atobj_sess_mgr]
        set addr [$self resource sessionAddr]
        set srm_sessn_ [Session/SRM create-session $sess_mgr_ $addr $sess_mgr_]
        set src_mgr_ [$srm_sessn_ set sm_]

        [$srm_sessn_ data-net] loopback 1
        [$srm_sessn_ ctrl-net] loopback 1

        $sess_mgr_ attach_session $srm_sessn_

        # REVIEW: once the initial startup problem has been resolved,
        # remove this line
        [$srm_sessn_ sa-timer] reset
}

ATP private init_args o {
	$self register_option $o -sa sessionAddr
	$self register_option $o -tf traceFile
	$self register_option $o -lf layoutFile
}

ATP instproc init_resources o {
        $self instvar class_

        $o add_option width  550
        $o add_default height 450
        $o add_default sessionAddr "225.4.5.5/8888"
#        catch "option readfile ~/.RTPdefaults startupFile"
}

ATP instproc initUI {} {
        set traceFile [$self resource traceFile]
        set layoutFile [$self resource layoutFile]

        if {$layoutFile!=""} {
                source $layoutFile
        }
        if {$traceFile!=""} {
                $self instvar sess_mgr_
                $self createLocalNam $traceFile $sess_mgr_
        }
        wm iconify .
}


ATP instproc init {argv} {
	set config [new Configuration]
	$self set options_ $config

        $self next atobj
        $self init_args $config
        $self init_resources $config
        $self parse_args $argv

        $self initNet
        $self initUI
}
