# ui-fonts.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/mbv2/ui-fonts.tcl,v 1.6 2002/02/03 04:21:59 lim Exp $


import Dialog DropDown


WidgetClass Dialog/SelectFont -superclass Dialog -default {
	{ .borderWidth 1 }
	{ .relief raised }
	{ .cursor arrow }
	{ .modal global }
	{ .transient . }
	{ *Checkbutton.borderWidth 1 }
	{ *Menubutton*borderWidth 1 }
	{ *Checkbutton*font WidgetDefault }
	{ *Menubutton*font WidgetDefault }
	{ *Entry.width 3 }
	{ .highlightThickness 0 }
	{ *DropDown/Text.highlightThickness 0 }
} -configspec {
	{ -font font Font {Helvetica 12 bold} config_font }
}



Dialog/SelectFont public build_widget { path } {
	wm overrideredirect $path 1

	frame $path.family_size
	label $path.family_label -text "Family"
	DropDown $path.family -variable [$self tkvarname family_]
	$path.family insert end Helvetica Times Courier

	label $path.size_label -text "Size"
	DropDown/Text $path.size -variable [$self tkvarname size_]
	$path.size insert end 6 8 10 12 14 16 18 20 24 28 32 36 40

	frame $path.options_sample
	frame $path.options -bd 2 -relief groove
	checkbutton $path.weight -text "Bold" -onvalue bold -offvalue normal \
			-variable [$self tkvarname weight_] -anchor w
	checkbutton $path.slant -text "Italics" -anchor w -onvalue italic \
			-offvalue roman -variable [$self tkvarname slant_]
	checkbutton $path.underline -text "Underline" -onvalue underline \
			-offvalue "" -variable [$self tkvarname underline_] \
			-anchor w
	checkbutton $path.overstrike -text "Overstrike" -onvalue overstrike \
			-offvalue "" -variable [$self tkvarname overstrike_] \
			-anchor w

	checkbutton $path.inpixels -text "Size in pixels" -anchor w \
			-variable [$self tkvarname sizeinpixels_] -pady 0
	frame $path.sample_frame -bd 2 -relief groove -width 75
	label $path.sample -text "ABC\nabc" -anchor w -padx 3 -justify left \
			-font {Helvetica -76 bold italic underline}

	pack $path.family_label -in $path.family_size -side left -fill y
	pack $path.family -in $path.family_size -side left -fill both -expand 1

	pack $path.size_label -in $path.family_size -side left -fill y
	pack $path.size -in $path.family_size -side left -fill both -expand 1

	pack $path.family_size -fill x -padx 3 -pady 2

	pack $path.weight $path.slant $path.underline $path.overstrike -fill x\
			-anchor w -in $path.options
	pack $path.options -fill x -padx 3 -pady 2 -in $path.options_sample \
			-side left

	pack $path.sample -in $path.sample_frame -fill both -expand 1
	pack propagate $path.sample_frame 0

	pack $path.inpixels -side top -fill x -anchor w \
			-in $path.options_sample
	pack $path.sample_frame -fill both -expand 1 -padx 3 -pady 2 \
			-in $path.options_sample -side top
	pack $path.options_sample -fill x -expand 1 -padx 3 -pady 2

	bind $path <ButtonPress-1> "$self button_down %W %x %y"

	$self tkvar family_ size_ weight_ slant_ underline_ overstrike_ \
			sizeinpixels_
	set family_ Helvetica
	set size_   12
	set weight_ bold
	set slant_  roman
	set underline_  ""
	set overstrike_ ""
	set sizeinpixels_ 0

	trace variable family_       w "$self font_changed"
	trace variable size_         w "$self font_changed"
	trace variable weight_       w "$self font_changed"
	trace variable slant_        w "$self font_changed"
	trace variable underline_    w "$self font_changed"
	trace variable overstrike_   w "$self font_changed"
	trace variable sizeinpixels_ w "$self font_changed"

	$self font_changed
}


Dialog/SelectFont public size_in_pixels { flag {never_change 0} } {
	$self tkvar sizeinpixels_
	set sizeinpixels_ $flag
	if $never_change { $self subwidget inpixels configure -state disabled}\
			else {$self subwidget inpixels configure -state normal}
}


Dialog/SelectFont private config_font { option args } {
	$self tkvar family_ size_ weight_ slant_ underline_ overstrike_ \
			sizeinpixels_
	$self instvar font_

	if { [llength $args] == 0 } {
		return $font_
	}

	set font [lindex $args 0]
	set family_ [lindex $font 0]
	set s [lindex $font 1]
	if { [string index $s 0] == "-" } {
		set size_ [string range $s 1 end]
		set sizeinpixels_ 1
	} else {
		set size_ $s
		set sizeinpixels_ 0
	}

	foreach style [lrange $font 2 end] {
		switch -exact -- $style {
			normal {
				set weight_ normal
				set w 1
			}
			bold {
				set weight_ bold
				set w 1
			}
			roman {
				set slant_ roman
				set s 1
			}
			italic {
				set slant_ italic
				set s 1
			}
			underline {
				set underline_ underline
				set u 1
			}
			overstrike {
				set overstrike_ overstrike
				set o 1
			}
		}
	}

	if ![info exists w] { set weight_ normal }
	if ![info exists s] { set slant_  roman  }
	if ![info exists u] { set underline_  "" }
	if ![info exists o] { set overstrike_ "" }

	$self configure -result $font_
}


Dialog/SelectFont private font_changed { args } {
	$self instvar font_ in_font_changed_
	$self tkvar family_ size_ weight_ slant_ underline_ overstrike_ \
			sizeinpixels_

	if [info exists in_font_changed_] return
	set in_font_changed_ 1
	if { ![regexp {^[0-9]+$} $size_] } { set size_ 12 } \
			elseif { $size_ < 4 } { set size_ 4 }

	if $sizeinpixels_ { set s -$size_ } else { set s $size_ }

	set font_ [concat $family_ $s $weight_ $slant_ $underline_ \
			$overstrike_]
	$self subwidget sample configure -font $font_
	unset in_font_changed_
}


Dialog/SelectFont private button_down { widget x y } {
	if { [winfo class $widget] == "Menubutton" } return
	set path [$self info path]
	set w [winfo width $path]
	set h [winfo height $path]

	if { $x < 0 || $x > $w || $y < 0 || $y > $h } {
		# we are out of the selection region
		# escape out
		$self instvar font_
		$self configure -font $font_
	}
}


Dialog/SelectFont public invoke { {widget {}} {x {}} {y {}} } {
	$self instvar x_ y_
	if { $x == {} && $y == {} } {
		if { $widget == {} } {
			catch {unset x_ y_}
		} else {
			set x_ [expr [winfo rootx $widget]]
			set y_ [expr [winfo rooty $widget] + \
					[winfo height $widget]]
		}
	} else {
		set x_ $x
		set y_ $y
	}

	$self next
}


Dialog/SelectFont public center { } {
	$self instvar x_ y_
	if { [info exists x_] && [info exists y_] } {
		set path [$self info path]
		wm withdraw $path
		update idletasks
		update
		wm geom $path +$x_+$y_
		wm deiconify $path
		raise $path
	} else {
		$self next
	}
}
