# agent-aries.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/aries/agent-aries.tcl,v 1.5 2002/02/03 04:21:08 lim Exp $


# Aries is a recording service for AS1.
Class AriesAgent

import ArchiveSystem/Record/Monitored SDPParser Program

# Start recording
AriesAgent public init {agent ssd} {
	$self instvar sdp_ archive_ archive_sys_

	set sdp_ $ssd

	set o [$self options]
	$o load_preferences "aries"

	set msg [lindex [ [new SDPParser 0] parse $sdp_] 0]
	set program [new Program $msg]
	#puts "Program: $program"

	set archive_ [$self get_option archive_root]
	append archive_ [$self get_option archive_dir]

	# FIX THIS : need filename to be unique and recreatable, for gather
	set module [string trim [clock clicks] -]

	set archive_sys_ [new ArchiveSystem/Record/Monitored]

	# Use the ArchiveSystem/Record class for recording and write
	# the SDP Program information to the catalog file.
	$archive_sys_ open $archive_ $module
	$archive_sys_ write_announcement $program

	# Write relevant recording information to the catalog file
	set current [$self readable_time [clock seconds]]
	set info "record_start=$current"
	$archive_sys_ write_info $info

	# Begin recording
	$archive_sys_ record_program $program $module


}

# Copied from Rec_Agent.  Should be in common?
AriesAgent private readable_time { time } {
    return [clock format $time -format {%a %B %d, %Y at %H:%M}]
}

# Stop recording
AriesAgent public close {} {
	$self instvar archive_sys_

	# Update the catalog file's info block to include the end time.
	set current [$self readable_time [clock seconds]]
	set info "record_end=$current"
	$archive_sys_ write_info $info

	# Close the recording in a clean fashion so that the end
	# timestamps in the header will be correct
	$archive_sys_ close
	delete $archive_sys_
}

# Fetch the list of ssrc's and error rates for the announcement
AriesAgent public get_ssd {} {
	$self instvar archive_sys_

	return [$archive_sys_ get_ssd]
}
