/*
 * srm.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srm_h
#define srm_h

#include "config.h"
#include <stdio.h>


#ifdef _MSC_VER
/*warning C4200: nonstandard extension used : zero-sized array in ...*/
#pragma warning( disable : 4200 )
#endif

#define SRM_VERSION 1
/* FIXME: remove this, should be internal variable of SRM */
#define SRM_MTU 1024

/* see comments on srmhdr for details */
#define SRM_COMPAT_BIT 1
#define SRM_PROTO 1

/* SRM types */

#define SRM_SA          1       /* state announcement packet */
#define SRM_REQUEST     2       /* repair request */
#define SRM_REPLY       3       /* repair reply */
#define SRM_BYE         4       /* terminate participation */
#define APP_DATA        5       /* Application data */
#define SRM_CNAME       6       /* Source CNAME description */

/* Very UNIX-centric and IP-centric. */
struct srm_src {
    u_int32_t ss_uid;		/* application definable USER-ID */
    u_int32_t ss_addr;		/* IP address of the machine */

    srm_src() : ss_uid(0), ss_addr(0) { }
    srm_src(const srm_src &src) : ss_uid(src.ss_uid), ss_addr(src.ss_addr) { }
    inline const srm_src &operator = (const srm_src &src) {
	ss_uid = src.ss_uid;
	ss_addr= src.ss_addr;
	return *this;
    }
    inline const srm_src &operator = (const char *srcString) {
        ss_uid = ss_addr = 0;
	sscanf(srcString, "%x@%x", &ss_uid, &ss_addr);
	return *this;
    }

    operator char * () const;
};

inline int operator==(const srm_src &s1, const srm_src &s2) {
  return s1.ss_uid==s2.ss_uid && s1.ss_addr==s2.ss_addr;
}

inline int operator!=(const srm_src &s1, const srm_src &s2) {
  return s1.ss_uid!=s2.ss_uid || s1.ss_addr!=s2.ss_addr;
}


/* Basic SRM header */
struct srmhdr {
	/* mash-5.0a9 (released Nov 1997) and before 'version' in
	 * bits 13 and 14. To share a common encryption module with rtp
	 * which uses bit 14 to indicate presence of padding, version bits
	 * are shifted to bits 7 & 8. Bit 13 is set permanently to 1
	 * for backward compatibility.
	 */
    u_int16_t sh_flags;	/* Proto:2, Pad: 1, Compat: 1,
			 * Pkt Type:4,
			 * Version:2, Reserved: 6*/
    u_int16_t sh_seqno;		/* sequence number */
    u_int32_t sh_ts;		/* time stamp */
    struct srm_src sh_src;	/* sender src id */
};

struct srm_adu {
    u_int16_t sa_type;		/* generic type info */
    u_int16_t sa_dlen;		/* length of data (adu's can be stacked) */
    u_int32_t sa_seqno;		/* name of data FIXME 32-bit no. for now */
    u_int32_t sa_ts;		/* time stamp FIXME (media-specific?)*/
};

struct srm_ctrl {
    u_int16_t sc_flags;		/* V:2 P:1 RECV:9 TYPE:4 */
    u_int16_t sc_len;		/* length of data (pkts can be stacked) */
    u_int32_t time;		/* What is this... will determine name */
};

/*
 *   t1
 *    \
 *       t2
 *       |
 *       t3
 *     /
 *  t4
 */

/* delay information */
struct srm_dinfo {
    srm_src di_ss;              /* the source relating to this delay info */
    float di_td;                /* td is t1 + t3 - t2, in 2^{-16} sec */
};

struct srm_sa {
    u_int32_t sa_nElt;
    srm_dinfo sa_arDInfo[0];    // an array of srm_dinfo (sa_nElt elements)
    /* followed by application sa info */
};


/* The SRM control packet has a chain of 'sl_count'
 * session announcements.
 */
struct sa_list {
    int sl_count;
    struct srm_announce *sl_sa;
};


#ifdef _MSC_VER
/*warning C4200: nonstandard extension used : zero-sized array in ...*/
#pragma warning( default : 4200 )
#endif


#endif

