/*
 * module-temp_select-indep.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "module-temp_select.h"

#define FRAME_HISTORY_LENGTH 2

class IndepTempSelectTargetState : public TemporalSelectTargetState {
public:
  IndepTempSelectTargetState() : TemporalSelectTargetState(),
    seq_no_(0) {};
  IndepTempSelectTargetState(u_int32_t id, Module *target) :
    TemporalSelectTargetState(id, target), seq_no_(0), tnext_(0), tprev_(0) {};

  u_int16_t seq_no_;
  IndepTempSelectTargetState *tnext_;
  IndepTempSelectTargetState *tprev_;
};

class IndepTempSelectModule : public TemporalSelectModule {
public:
  IndepTempSelectModule() : TemporalSelectModule(),
    cur_ts_(0), oldest_history_(0), cur_target_state_(0) {};

  virtual void recv(pktbuf *pb);
  virtual void update_target(u_int32_t target_id,
			     TemporalSelectTargetState *state);
  virtual TemporalSelectTargetState *register_target(u_int32_t id,
						     Module *target);
  virtual void unregister_target(u_int32_t id,
				 TemporalSelectTargetState *state);
  virtual int command(int argc, const char*const* argv);

protected:
  class FrameHistory {
  public:
    FrameHistory() : ts_(0), target_state_(0) {};
    u_int32_t ts_;
    IndepTempSelectTargetState *target_state_;
  };

  class PktBufQueue {
  public:
    PktBufQueue() : q_array_size_(16), q_idx_(0) {
      q_array_ = (pktbuf **) malloc(sizeof(pktbuf *) * q_array_size_);
    };
    pktbuf **q_array_;
    int q_array_size_;
    int q_idx_;
    inline void insert(pktbuf *pb) {
      if (q_idx_ == q_array_size_) {
	q_array_size_ += 16;
	q_array_ = (pktbuf **) realloc(q_array_,
				       sizeof(pktbuf *) * q_array_size_);
      }
      q_array_[q_idx_] = pb;
      q_idx_++;
    };
    inline pktbuf *get(int idx) {
      if (idx >= q_idx_) {
	return 0;
      } else {
	return q_array_[idx];
      }
    };
    inline void release_all() {
      int idx;

      for(idx = 0; idx < q_idx_; idx++) {
	q_array_[idx]->release();
      }
      q_idx_ = 0;
    };
  } q_;

  u_int32_t cur_ts_;
  FrameHistory history_[FRAME_HISTORY_LENGTH];
  int oldest_history_;
  IndepTempSelectTargetState *cur_target_state_;
};

static class IndepTempSelectModuleClass : public TclClass {
public:
  IndepTempSelectModuleClass() : TclClass("Module/Selector/Temporal/Indep") {}
  TclObject* create(int, const char*const*) {
    return (new IndepTempSelectModule());
  }
} temp_select_indep_class;


void
IndepTempSelectModule::recv(pktbuf *pb)
{
  rtphdr *rh =  (rtphdr *) pb->data;
  u_int32_t ts = ntohl(rh->rh_ts);

  if (ts > cur_ts_) {
    q_.release_all();

    history_[oldest_history_].ts_ = cur_ts_;
    history_[oldest_history_].target_state_ = cur_target_state_;
    oldest_history_ = (oldest_history_+1)%FRAME_HISTORY_LENGTH;

    cur_ts_ = ts;
    q_.insert(pb);
    cur_target_state_ = 0;

    execute_callback(ts);
    return;
  } else if (ts == cur_ts_) {
    if (cur_target_state_ != 0) {
      IndepTempSelectTargetState *s;

      s = cur_target_state_;

      while (s != NULL) {
	rh->rh_seqno = htons(s->seq_no_++);
	rh->rh_ssrc = htonl(s->id_);

	/*	pb->attach(); */
	pktbuf *cpb = (pktbuf *) pb->copy();
	s->target_->recv(cpb);

	s = s->tnext_;
      }
    }
    q_.insert(pb);
    return;
  } else {
    /* Check history */
    int i;

    for(i=0; i<FRAME_HISTORY_LENGTH; i++) {
      if (history_[i].ts_ == ts) {
	IndepTempSelectTargetState *s = history_[i].target_state_;

	while (s != 0) {
	  rh->rh_seqno = htons(s->seq_no_++);
	  rh->rh_ssrc = htonl(s->id_);

	  /*	  pb->attach(); */
	  pktbuf *cpb = (pktbuf *) pb->copy();
	  s->target_->recv(cpb);

	  s = s->tnext_;
	}
	pb->release();
	return;
      }
    }
    pb->release();
    return;
  }
}

TemporalSelectTargetState *
IndepTempSelectModule::register_target(u_int32_t id, Module *target)
{
  IndepTempSelectTargetState *new_state =
    new IndepTempSelectTargetState(id, target);

  return ((TemporalSelectTargetState *) new_state);
}

void
IndepTempSelectModule::unregister_target(u_int32_t id,
					 TemporalSelectTargetState *state)
{
  IndepTempSelectTargetState *indep_state = (IndepTempSelectTargetState *) state;
  IndepTempSelectTargetState *s;
  int i;

  s = cur_target_state_;
  while (s != 0) {
    if (indep_state == s)
      break;
    s = s->tnext_;
  }

  if (s != 0) {
    if (s->tprev_ == 0) {
      cur_target_state_ = s->tnext_;
    } else {
      s->tprev_->tnext_ = s->tnext_;
    }
    if (s->tnext_ != 0) {
      s->tnext_->tprev_ = s->tprev_;
    }
    s->tnext_ = s->tprev_ = 0;
  } else {
    for (i=0; i<FRAME_HISTORY_LENGTH; i++) {
      s = history_[i].target_state_;

      while (s != 0) {
	if (indep_state == s)
	  break;
	s = s->tnext_;
      }

      if (s != 0) {
	if (s->tprev_ == 0) {
	  history_[i].target_state_ = s->tnext_;
	} else {
	  s->tprev_->tnext_ = s->tnext_;
	}
	if (s->tnext_ != 0) {
	  s->tnext_->tprev_ = s->tprev_;
	}
	s->tnext_ = s->tprev_ = 0;
	break;
      }
    }
  }
  delete indep_state;
};

void
IndepTempSelectModule::update_target(u_int32_t target_id,
				    TemporalSelectTargetState *state)
{
  IndepTempSelectTargetState *istate = (IndepTempSelectTargetState *) state;
  pktbuf *pb;
  rtphdr *rh;
  int i;

  if (istate->tprev_ != 0) {
    istate->tprev_->tnext_ = istate->tnext_;
  } else {
    if (istate == cur_target_state_) {
      cur_target_state_ = istate->tnext_;
    } else {
      for (i=0; i<FRAME_HISTORY_LENGTH; i++) {
	if (istate == history_[i].target_state_) {
	 history_[i].target_state_ = istate->tnext_;
	  break;
	}
      }
    }
  }
  if (istate->tnext_ != 0) {
    istate->tnext_->tprev_ = istate->tprev_;
  }
  istate->tnext_ = istate->tprev_ = 0;

  istate->tnext_ = cur_target_state_;
  if (cur_target_state_ != 0) {
    cur_target_state_->tprev_ = istate;
  }
  cur_target_state_ = istate;

  i = 0;
  pb = q_.get(i++);

  while (pb != 0) {
    rh = (rtphdr *) pb->data;
    rh->rh_seqno = htons(istate->seq_no_++);
    rh->rh_ssrc = htonl(istate->id_);

    /* pb->attach(); */
    pktbuf *cpb = (pktbuf *) pb->copy();
    istate->target_->recv(cpb);

    pb = q_.get(i++);
  }
  return;
}

int
IndepTempSelectModule::command(int argc, const char*const* argv)
{
  Tcl& tcl = Tcl::instance();

  if (argc == 2) {
    if (strcmp(argv[1], "get_current_ts") == 0) {
      char *wrk = tcl.buffer();

      sprintf(wrk, "%u", cur_ts_);
      tcl.result(wrk);
      return(TCL_OK);
    }
  }
  return (TemporalSelectModule::command(argc, argv));
}
