dnl configure.in.tcl --
dnl
dnl     autoconf rules to find tcl
dnl
dnl Copyright (c) 2000-2002 The Regents of the University of California.
dnl All rights reserved.
dnl
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that the following conditions are met:
dnl
dnl A. Redistributions of source code must retain the above copyright notice,
dnl    this list of conditions and the following disclaimer.
dnl B. Redistributions in binary form must reproduce the above copyright
dnl    notice, this list of conditions and the following disclaimer in the
dnl    documentation and/or other materials provided with the distribution.
dnl C. Neither the names of the copyright holders nor the names of its
dnl    contributors may be used to endorse or promote products derived from
dnl    this software without specific prior written permission.
dnl
dnl THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
dnl IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
dnl THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
dnl PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
dnl LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
dnl CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
dnl SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
dnl INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
dnl CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
dnl ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
dnl POSSIBILITY OF SUCH DAMAGE.
dnl
dnl $Header: /usr/mash/src/repository/conf/configure.in.tcl,v 1.10 2002/02/07 17:21:38 lim Exp $

AC_ARG_WITH(tcl, [  --with-tcl=path	specify a pathname for tcl], d=$withval, d="")

AC_ARG_WITH(tcl-ver, [  --with-tcl-ver=path	specify the version of tcl], TCL_VERS=$withval, TCL_VERS=8.3.3)

dnl Truncate anything beyond and including the second decimal point

TCL_HI_VERS=`echo $TCL_VERS | sed 's/^\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\)/\1.\2/'`
TCL_MAJOR_VERS=`echo $TCL_VERS | sed 's/^\([[0-9]]*\)\.\([[0-9]]*\)\.\([[0-9]]*\)/\1/'`
TCL_ALT_VERS=`echo $TCL_HI_VERS | sed 's/\.//'`

dnl work with one version in the past
TCL_OLD_VERS=7.6
TCL_OLD_ALT_VERS=`echo $TCL_OLD_VERS | sed 's/\.//'`

dnl These paths are pretty hellish and should probably be pruned.
TCL_TCL_PLACES_D="$d \
		$d/lib/tcl$TCL_HI_VERS \
		$d/lib/tcl$TCL_VERS \
		$d/lib/tcl$TCL_ALT_VERS \
		$d/lib/tcl \
		$d/../lib/tcl$TCL_HI_VERS \
		$d/../lib/tcl$TCL_VERS \
		$d/../lib/tcl$TCL_ALT_VERS \
		$d/lib/tcl$TCL_OLD_VERS \
		$d/lib/tcl$TCL_OLD_ALT_VERS \
		$d/../lib/tcl$TCL_OLD_VERS \
		$d/../lib/tcl$TCL_OLD_ALT_VERS \
		$d/lib \
		$d/library \
		$d/../library"
TCL_TCL_PLACES="../lib/tcl$TCL_HI_VERS \
		../lib/tcl$TCL_ALT_VERS \
		../lib/tcl$TCL_VERS \
		../lib/tcl \
		../tcl$TCL_HI_VERS/library \
		../tcl$TCL_VERS/library \
                ../tcl$TCL_ALT_VERS/library \
		/usr/lib/tcl$TCL_VERS \
		/usr/lib/tcl$TCL_HI_VERS \
		/usr/lib/tcl$TCL_ALT_VERS \
		/usr/lib/tcl \
		/lib/tcl$TCL_VERS \
		/lib/tcl$TCL_HI_VERS \
		/lib/tcl$TCL_ALT_VERS \
		/usr/lib/tcl$TCL_OLD_VERS \
		/usr/lib/tcl$TCL_OLD_ALT_VERS \
		/lib/tcl$TCL_OLD_VERS \
		/lib/tcl$TCL_OLD_ALT_VERS \
		/usr/lib \
                /usr/src/local/tcl$TCL_VERS/library \
                /usr/src/local/tcl$TCL_HI_VERS/library \
                /usr/src/local/tcl$TCL_ALT_VERS/library \
                /usr/local/lib/tcl$TCL_VERS \
                /usr/local/lib/tcl$TCL_HI_VERS \
                /usr/local/lib/tcl$TCL_ALT_VERS \
                /usr/local/include/tcl$TCL_VERS \
                /usr/local/include/tcl$TCL_HI_VERS \
                /usr/local/include/tcl$TCL_ALT_VERS \
		../tcl$TCL_OLD_VERS/library \
                ../tcl$TCL_OLD_ALT_VERS/library \
                /usr/src/local/tcl$TCL_OLD_VERS/library \
                /usr/src/local/tcl$TCL_OLD_ALT_VERS/library \
                /usr/local/lib/tcl$TCL_OLD_VERS \
                /usr/local/lib/tcl$TCL_OLD_ALT_VERS \
                /usr/local/include/tcl$TCL_OLD_VERS \
                /usr/local/include/tcl$TCL_OLD_ALT_VERS \
                /usr/local/include \
                $prefix/include \
		$prefix/lib/tcl \
                $x_includes/tk \
                $x_includes \
                /usr/contrib/include \
                /usr/include"
TCL_H_PLACES_D="$d/generic \
		$d/../generic \
		$d/unix \
		$d/include/tcl$TCL_HI_VERS \
		$d/include/tcl$TCL_VERS \
		$d/include/tcl$TCL_ALT_VERS \
		$d/include \
		"
TCL_H_PLACES=" \
		../include \
		../tcl$TCL_VERS/unix \
		../tcl$TCL_ALT_VERS/unix \
		../tcl$TCL_HI_VERS/generic \
		../tcl$TCL_VERS/generic \
		../tcl$TCL_ALT_VERS/generic \
		/usr/src/local/tcl$TCL_VERS/generic \
		/usr/src/local/tcl$TCL_HI_VERS/generic \
		/usr/src/local/tcl$TCL_ALT_VERS/generic \
		/usr/src/local/tcl$TCL_VERS/unix \
		/usr/src/local/tcl$TCL_HI_VERS/unix \
		/usr/src/local/tcl$TCL_ALT_VERS/unix \
		/usr/contrib/include \
		/usr/local/lib/tcl$TCL_VERS \
		/usr/local/lib/tcl$TCL_HI_VERS \
		/usr/local/lib/tcl$TCL_ALT_VERS \
		/usr/local/include/tcl$TCL_VERS \
		/usr/local/include/tcl$TCL_HI_VERS \
		/usr/local/include/tcl$TCL_ALT_VERS \
		/usr/local/include \
		/import/tcl/include/tcl$TCL_VERS \
		/import/tcl/include/tcl$TCL_HI_VERS \
		/import/tcl/include/tcl$TCL_ALT_VERS \
		../tcl$TCL_OLD_VERS/generic \
		../tcl$TCL_OLD_ALT_VERS/generic \
		/usr/src/local/tcl$TCL_OLD_VERS/generic \
		/usr/src/local/tcl$TCL_OLD_ALT_VERS/generic \
		../tcl$TCL_OLD_VERS/unix \
		../tcl$TCL_OLD_ALT_VERS/unix \
		/usr/src/local/tcl$TCL_OLD_VERS/unix \
		/usr/src/local/tcl$TCL_OLD_ALT_VERS/unix \
		/usr/local/lib/tcl$TCL_OLD_VERS \
		/usr/local/lib/tcl$TCL_OLD_ALT_VERS \
		/usr/local/include/tcl$TCL_OLD_VERS \
		/usr/local/include/tcl$TCL_OLD_ALT_VERS \
		/import/tcl/include/tcl$TCL_OLD_VERS \
		/import/tcl/include/tcl$TCL_OLD_ALT_VERS \
		$prefix/include \
		$x_includes/tk \
		$x_includes \
		/usr/include \
		/usr/include/tcl$TCL_VERS \
		/usr/include/tcl$TCL_HI_VERS \
		/usr/include/tcl$TCL_ALT_VERS \
		/usr/include/tcl"
dnl /usr/include/tcl is for Debian Linux
TCL_LIB_PLACES_D="$d \
		$d/lib \
		$d/unix"
TCL_LIB_PLACES=" \
		../lib \
		../tcl$TCL_VERS/unix \
		../tcl$TCL_HI_VERS/unix \
                ../tcl$TCL_ALT_VERS/unix \
                /usr/src/local/tcl$TCL_VERS/unix \
                /usr/src/local/tcl$TCL_HI_VERS/unix \
                /usr/src/local/tcl$TCL_ALT_VERS/unix \
                /usr/contrib/lib \
                /usr/local/lib/tcl$TCL_VERS \
                /usr/local/lib/tcl$TCL_HI_VERS \
                /usr/local/lib/tcl$TCL_ALT_VERS \
		/usr/lib/tcl$TCL_VERS \
		/usr/lib/tcl$TCL_HI_VERS \
		/usr/lib/tcl$TCL_ALT_VERS \
		../tcl$TCL_OLD_VERS/unix \
                ../tcl$TCL_OLD_ALT_VERS/unix \
                /usr/src/local/tcl$TCL_OLD_VERS/unix \
                /usr/src/local/tcl$TCL_OLD_ALT_VERS/unix \
                /usr/local/lib/tcl$TCL_OLD_VERS \
                /usr/local/lib/tcl$TCL_OLD_ALT_VERS \
		/usr/lib/tcl$TCL_OLD_VERS \
		/usr/lib/tcl$TCL_OLD_ALT_VERS \
                /usr/local/lib \
                $prefix/lib \
                $x_libs/tk \
                $x_libs \
                /usr/lib \
		"

dnl
dnl If the --with-tcl argument points to a build directory that
dnl is separate from the source directory, try to read tclConfig.sh
dnl to chase it back to the source and add that directory to
dnl some search paths.
dnl

if test -r $d/tclConfig.sh ; then
	d2=`(. $d/tclConfig.sh ; echo $TCL_SRC_DIR)`

	TCL_TCL_PLACES_D="${TCL_TCL_PLACES_D} $d2/library"
	TCL_H_PLACES_D="${TCL_H_PLACES_D} $d2/generic"
fi


dnl Decide which set of .tcl library files to use
dnl FIXME: this is a hack

V_TCL_LIBRARY_FILES="\$(TCL_`echo $TCL_ALT_VERS`_LIBRARY_FILES)"
AC_SUBST(V_TCL_LIBRARY_FILES)


NS_BEGIN_PACKAGE(tcl)
NS_CHECK_HEADER_PATH(tcl.h,$TCL_H_PLACES,$d,$TCL_H_PLACES_D,V_INCLUDE_TCL,tcl)
NS_CHECK_LIB_PATH(tcl$TCL_HI_VERS,$TCL_LIB_PLACES,$d,$TCL_LIB_PLACES_D,V_LIB_TCL,tcl)
NS_CHECK_ANY_PATH(init.tcl,$TCL_TCL_PLACES,$d,$TCL_TCL_PLACES_D,V_LIBRARY_TCL,tcl)

#
# check for tclsh
#
# We need to check the possible paths separately to avoid picking up a
# non-working local version of tclsh instead of the working tclsh distributed
# with Mash.
#
# First, check user-specified Tcl path, if specified.
# $d alone works if the --with-tcl arg points to the build dir
# $d/unix works if $d is the 8.0 distribution
# $d/bin is for the ns-allinone distribution (kind of hacky, isn't it?)
#
if test x"$d" = x; then
    V_TCLSH=no
else
    AC_PATH_PROGS(V_TCLSH,tclsh$TCL_VERS tclsh$TCL_HI_VERS tclsh tclsh$TCL_OLD_VERS,no,$d:$d/unix:$d/bin)
fi
if test x"$V_TCLSH" = xno; then
    #
    # Next, check Tcl distributed with Mash.
    #
    AC_PATH_PROGS(V_TCLSH,tclsh$TCL_VERS tclsh$TCL_HI_VERS tclsh tclsh$TCL_OLD_VERS,no,../tcl$TCL_VERS/unix:../tcl$TCL_HI_VERS/unix)
    if test x"$V_TCLSH" = xno; then
        #
        # Last resort, check user's path.
        #
        AC_PATH_PROGS(V_TCLSH,tclsh$TCL_VERS tclsh$TCL_HI_VERS tclsh tclsh$TCL_OLD_VERS,no)
        if test x"$V_TCLSH" = xno; then
            # out of luck
            NS_PACKAGE_NOT_COMPLETE(tcl)
        fi
    fi
fi
# absolutize it
V_TCLSH=`absolutize $V_TCLSH`

# in case this tclsh has not been installed, make sure we
# give it the full path to the runtime library files
V_TCLSH="env TCL_LIBRARY=$V_LIBRARY_TCL $V_TCLSH"

NS_END_PACKAGE(tcl,yes)

AC_SUBST(V_LIBRARY_TCL)
