/*
 * p64dump.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

class P64Dumper: public FullP64Decoder {
    public:
	P64Dumper();
	P64Dumper(int q);
	int decode(const u_char* bp, int cc, int sbit, int ebit,
		   int mba, int gob, int mq, int mvdh, int mvdv);
   protected:
	void err(const char* msg ...) const;
	void dump_bits(char c);
#ifdef INT_64
	int parse_block(short* blk, INT_64* mask);
#else
	int parse_block(short* blk, u_int* mask);
#endif
	void decode_block(u_int tc, u_int x, u_int y, u_int stride,
			  u_char* front, u_char* back, int sf, int n);
	int parse_picture_hdr();
	int parse_sc();
	int parse_gob_hdr(int);
	int parse_mb_hdr(u_int& cbp);

	int decode_gob(u_int gob);
	int decode_mb();

	u_int dbb_;		/* 32-bit bit buffer */
	int dnbb_;		/* number bits in bit buffer */
	const u_short* dbs_;	/* input bit stream (less bits in bb_) */
	int dump_quantized_;	/* dump quantized coef. values if = 1 */
};
