/*
 * module.cc --
 *
 *      Modules for video codecs
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/codec/module.cc,v 1.13 2002/02/03 03:13:33 lim Exp $";
#endif

#include "module.h"

class DataInputHandlerClass : public TclClass {
public:
	DataInputHandlerClass() : TclClass("Module/DataHandler") {}
	TclObject* create(int, const char*const*) {
		return(new DataInputHandler);
	}
} data_input_module_class;

class ControlInputHandlerClass : public TclClass {
public:
	ControlInputHandlerClass() : TclClass("Module/ControlHandler") {}
	TclObject* create(int, const char*const*) {
		return(new ControlInputHandler);
	}
} ctrl_input_module_class;

void Buffer::release()
{
}

Module::Module() : next(0), target_(0)
{
}

FrameModule::FrameModule()
	: width_(0), height_(0), framesize_(0)
{
}

int Module::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();

	// let the encoder choose the color-subsampling scheme
	if (argc == 2 && strcmp(argv[1], "frame-format") == 0) {
		tcl.result("422");
		return (TCL_OK);
	}

	if (argc == 2) {
		if (strcmp(argv[1], "target") == 0) {
			if (target_ != 0)
				tcl.result(target_->name());
			return (TCL_OK);
		}
	}
	if (argc == 3) {
		if (strcmp(argv[1], "target") == 0) {
			target_ = (Module*)TclObject::lookup(argv[2]);
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}

EncoderModule::EncoderModule() : pool_(0), mtu_(1024), nb_(0)
{
	bind("nb_", (int*)&nb_);
}

int EncoderModule::command(int argc, const char*const* argv)
{
        if (argc == 3) {
                if (strcmp(argv[1], "buffer-pool") == 0) {
                        pool_ = (RTP_BufferPool*)TclObject::lookup(argv[2]);
                        return (TCL_OK);
                }
                if (strcmp(argv[1], "mtu") == 0) {
                        mtu_ = atoi(argv[2]);
                        return (TCL_OK);
                }
        }
        return (FrameModule::command(argc, argv));
}
