/*
 * decoder-mp3.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/decoder-mp3.cc,v 1.2 2002/02/03 03:10:46 lim Exp $ (LBL)";

#include "decoder.h"
#include "controller.h"
#include "pktbuf.h"
extern "C" {
#include "../../lame/include/lame.h"
}

class MP3Decoder : public PCM_Decoder {
    public:
	MP3Decoder();
	virtual void recv(pktbuf*);
    private:
        short left[8192], right[8192];
};

static class MP3DecoderClass : public TclClass {
    public:
	MP3DecoderClass() : TclClass("Module/AudioDecoder/MP3") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new MP3Decoder);
	};
} mp3_decoder_class;

MP3Decoder::MP3Decoder()
{
        lame_decode_init();
}

void MP3Decoder::recv(pktbuf* pb)
{
	const struct rtphdr* rh = (rtphdr*)pb->dp;
	const u_int8_t* frame = (u_int8_t*)(rh + 1);
	int len = pb->len - sizeof(*rh);
	int outlen;

	if (active()) {
	  outlen = lame_decode((unsigned char*)frame, len, left, right);
	  if (outlen)
	    consume_samples(rh, (u_int8_t*)left, outlen*2);
	}
	pb->release();
}
