/*
 * decoder-gsm.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/decoder-gsm.cc,v 1.8 2002/02/03 03:10:46 lim Exp $";

#include "decoder.h"
#include "controller.h"
extern "C" {
#include "gsm.h"
}

class GSMDecoder : public PCM_Decoder {
    public:
	GSMDecoder();
	virtual void recv(pktbuf* pb);
    private:
	int nframes;
	gsm_state rstate_;
};

static class GSMDecoderClass : public TclClass {
    public:
	GSMDecoderClass() : TclClass("Module/AudioDecoder/GSM") {}
	TclObject* create(int, const char*const*) {
		return (new GSMDecoder);
	};
} gsm_decoder_class;

GSMDecoder::GSMDecoder()
{
	Vat_Gsm_InitR(&rstate_);
}

void GSMDecoder::recv(pktbuf* pb)
{
	const struct rtphdr* rh = (rtphdr*)pb->dp;
	const u_int8_t* frame = (u_int8_t*)(rh + 1);
	int len = pb->len - sizeof(*rh);
	if (active()) {
		if (len >= 33 && len <= 8 * 33) {
			u_char wrkbuf[AUDIO_FRAMESIZE*8];
			u_char* wp = wrkbuf;
			int outlen = 0;
			for (const u_char* ep = frame + len; frame < ep;
			     wp += framesize_, frame += 33) {
				Vat_Gsm_Decoder(&rstate_, wp, frame);
				outlen += framesize_;
			}
			consume_samples(rh, wrkbuf, outlen);
		}
	}
	pb->release();
}
