/*
 * atobj-rreq.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Header: /usr/mash/src/repository/mash/mash-1/atobj/atobj-rreq.h,v 1.5 2002/02/03 03:10:21 lim Exp $
 */

#ifndef ATOBJ_RREQ_H
#define ATOBJ_RREQ_H

#include "atobj-rcvr.h"
#include "session-srm.h"

class AtobjRcvr;

class Atobj_request : public SRM_Request {
public:
        Atobj_request(AtobjRcvr* pRcvr, const AnimationId& anmId)
                : SRM_Request(),
                  pRcvr_(pRcvr), numtimes_(0), anmId_(anmId)
                {}
        ~Atobj_request() {}

        int fill_ADU(Byte* pb, int len);
        /*virtual from SRM_Request*/
        virtual int fill_ADU() {
                // REVIEW: get the len right!
                return fill_ADU(pb_->data+sizeof(srmhdr), SRM_MTU);
        }

private:
        AtobjRcvr *pRcvr_;
        int numtimes_;
        AnimationId anmId_;
};


class Atobj_reply : public SRM_Reply {
public:
        Atobj_reply(AtobjRcvr* pRcvr, const AnimationId& anmId)
                : SRM_Reply(),
                pRcvr_(pRcvr), anmId_(anmId)  {}
        ~Atobj_reply() {}

        int fill_ADU(Byte* pb, int len);
        /*virtual from SRM_Request*/
        virtual int fill_ADU() {
                // REVIEW: get the len right!
                return fill_ADU(pb_->data+sizeof(srmhdr), SRM_MTU);
        }

private:
        AtobjRcvr *pRcvr_;
        AnimationId anmId_;     // need this for receiver to call up the right
                                // datasrc...
};

#endif /* #ifdef ATOBJ_RREQ_H */
