/*
 * mb-record.h --
 *
 *      MediaBoard Recoder header file
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/archive/mb-record.h,v 1.13 2002/02/03 03:09:26 lim Exp $
 */



#ifndef MASH_MB_RECORD_H
#define MASH_MB_RECORD_H


#include "archive/mb-archive.h"
class MBRecordStream;
class MBRecordPage;


class MBRecordRcvr : public MBBaseRcvr {
public:
	MBRecordRcvr(MBBaseMgr *pMgr, const SrcId &srcId);
	~MBRecordRcvr();

	void attach(MBRecordStream *stream) { stream_ = stream; }
	MBRecordStream *stream() { return stream_; }

private:
	virtual int executeCmd(MBCmd* /*pCmd*/, MBPageObject* /*pPage*/,
			       const MBTime& /*oldTime*/,
                               const MBTime& /*newTime*/)
		{
			// don't do anything!
			return MB_EXE_OK;
		}
	virtual void recvCommands(Byte *pb, u_int len, Bool isReply);

	MBRecordStream *stream_;
};


class MBRecordStream : public RecordStream {
public:
	MBRecordStream()
		: RecordStream(),
		  rcvr_(NULL),
		  bytesWritten_(0),
		  mustRewriteHdr_(false) { }
	virtual ~MBRecordStream() {
		// before destroying this object, write out the
		// latest timestamp values into the header
		WriteHeaders();
	}

	void attach(MBRecordRcvr *rcvr) { rcvr_ = rcvr; }
	Bool Record(MBRecordPage *pPage);
	int  WriteHeaders();
	int  SeekToStartOfData();
	FileHeader *FileHeader_() { return &hdr_; }
	int init_file_header(int argc, const char * const *argv);
	int write_headers(int argc, const char * const *argv);
	void MustRewriteHdr() { mustRewriteHdr_ = true; }
private:
	MBRecordRcvr *rcvr_;
	DataBuffer buffer_;
	FileHeader hdr_;
	u_int32_t bytesWritten_;
	Bool mustRewriteHdr_;
};


class MBRecordPage : public MBPageObject {
public:
	MBRecordPage(MBBaseMgr *pMgr, const PageId &pgId)
		: MBPageObject(pMgr, pgId), lastRecorded_(0) { };
	u_int32_t LastRecorded() { return lastRecorded_; }
	void LastRecorded(u_int32_t l) { lastRecorded_ = l; }
private:
	u_int32_t lastRecorded_;
};


class MBRecordMgr : public MBBaseMgr {
public:
	// virtual SRM_AppMgr functions
	virtual int next_ADU(Byte* /*pb*/, int /*len*/, int* /*type*/,
			     srm_src& /*addr*/, int& /*next = 0*/) {
		return 0;
	}

	MBRecordMgr() { }
	virtual ~MBRecordMgr() { }
	int cname_update(int argc, const char * const *argv);

private:
	virtual int periodic_update(Byte * /*pb*/) {
		Tcl::instance().evalf("%s reset",
				      session()->sa_timer()->name());
		return 0;
	}

	virtual void handle_request(Byte * /*pb*/, int /*len*/) {
	}

	virtual Bool isVisible(const PageId &/*pgId*/) {
		// all pages are considered "visible", so SRM can make a
		// repair-request if it needs one
		return TRUE;
	}
	virtual void activity(MBPageObject* /*pPage*/, MBCmd* /*pCmd*/) {}

	virtual MBBaseRcvr   *NewReceiver(const SrcId &srcId,
					  Bool /*isLocal*/);

	virtual MBPageObject *NewPageObject(const PageId &pageId,
					    Bool /*newPage*/) {
		return new MBRecordPage(this, pageId);
	}
};


#endif /* MASH_MB_RECORD_H */
