# callback-lib.tcl --
#
#       Library for registering/executing AMX callbacks for AMX events.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_clients g_clientInfo

proc callback_register {callback {filterExpr ""}} {
    global g_clients g_clientInfo

    set sock [rpcFile]

    if {$sock == ""} {
	set sock "local"
    }
    
    puts stdout "callback_register $sock -> $callback"

    set g_clients($sock) $sock
    set g_clientInfo($sock,sock) $sock
    set g_clientInfo($sock,procs,$callback) $callback
    set g_clientInfo($sock,enables,$callback) 0
    set g_clientInfo($sock,filters,$callback) $filterExpr
    
    # the call to this depends on if you use "set" or "append" as the option
    #   arg to dp_atclose
    # append - if you try to group the unregisterClient $sock as
    #   "unregisterClient $sock", it will cause an error!
    # set - you must use "unregisterClient $sock" or it will cause an error!
    dp_atclose $sock set "callback_unregisterClient $sock"
}

proc callback_unregister {callback} {
    global g_clients g_clientInfo

    set sock [rpcFile]
    if {$sock == ""} {
	set sock "local"
    }
    if {![info exists g_clientInfo($sock,procs,$callback)]} {
	return
    }

    puts stdout "unregistering sock=$sock, callback=$callback"
    unset g_clientInfo($sock,procs,$callback)
    unset g_clientInfo($sock,enables,$callback)
    unset g_clientInfo($sock,filters,$callback)
}


proc callback_unregisterClient { sock } {
    global g_clients g_clientInfo
    
    unset g_clientInfo($sock,sock)
    foreach index [array names g_clientInfo "$sock,procs,*"] {
	unset g_clientInfo($index)
    }
    foreach index [array names g_clientInfo "$sock,enables,*"] {
	unset g_clientInfo($index)
    }
    foreach index [array names g_clientInfo "$sock,filters,*"] {
	unset g_clientInfo($index)
    }
    unset g_clients($sock)
}

proc callback_disable {callback} {
    global g_clients g_clientInfo

    set sock [rpcFile]
    if {$sock == ""} {
	set sock "local"
    }
    if {![info exists g_clientInfo($sock,procs,$callback)]} {
	return
    }

    puts stdout "disabling sock=$sock, callback=$callback"
    
    set g_clientInfo($sock,enables,$callback) 0 
}

proc callback_enable {callback} {
    global g_clients g_clientInfo

    set sock [rpcFile]
    if {$sock == ""} {
	set sock "local"
    }
#    puts stdout "checking for $sock,procs,$callback"
    if {![info exists g_clientInfo($sock,procs,$callback)]} {
	return -code error "Error: callback_register must be called before calls to callback_enable: while enabling \"$callback\""
    }

    set g_clientInfo($sock,enables,$callback) 1
}

# arg is a tcl list consisting of:
#
# arg[0] = eventInfo list - consist of
#          eventInfo[0] = type [amxResponse,remoteCommand,matrixSwitch]
#          eventInfo[1] = ??? (reserved)
#
# arg[1] = eventData list - content varies depending on type
#
# AMX response/remote command
#   eventData[0] = AMX command
#   eventData[1] = AMX device
#   eventData[2] = device channel OR string
#
# matrix swtich
#   eventData[0] = input
#   eventData[1] = output
#
proc callback_doCallbacks { arg } {
    global g_clients g_clientInfo

#puts stdout "doing callbacks"
    
    if [array exists g_clients] {
	foreach index [array names g_clients] {
	    set sock $g_clientInfo($index,sock)
	    foreach index2 [array names g_clientInfo "$index,procs,*"] {
		set proc $g_clientInfo($index2)
		set enable $g_clientInfo($sock,enables,$proc)
		set filter $g_clientInfo($sock,filters,$proc)
#puts stdout "index=$index: sock=$sock, proc=$proc, enable=$enable"
		if {$proc != ""} {
		    if {$enable} {			
			set doCallback 1
			if {$filter != ""} {
			    if {[catch {eval $filter} result]} {
				puts stdout "error evaling filter"
				puts stdout "\tsock=$sock callback=$proc"
				puts stdout "\terror=$result"
			    }
			}
			if {$doCallback} {
			    #puts stdout "executing $proc"
			    if {$sock != "local"} {
				# it is from an RPC client
				# FIXME - this catch won't ever be active because
				#   dp_RDO doesn't return the result
				if {[catch {dp_RDO $sock $proc $arg} result]} {
				    puts stdout "error executing callback"
				    puts stdout "\tsock=$sock callback=$proc"
				    puts stdout "\terror=$result"
				} 
			    } else {
				if {[catch {$proc $arg} result]} {
				    puts stdout "error executing callback"
				    puts stdout "\tsock=$sock callback=$proc"
				    puts stdout "\terror=$result"
				}
			    }
			}
		    }
		}
	    }
	}
    }
}

