/*
 * net-ip.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/net/net-ip.h,v 1.6 2002/02/03 03:03:19 lim Exp $ (LBL)
 */

#ifndef net_ip_h
#define net_ip_h

#include "net.h"
#include <stdio.h>
#include <errno.h>
#include <string.h>
#if defined(_AIX) || defined(sun)
#include <strings.h>
#endif
#ifdef WIN32
#include <io.h>
#define close closesocket
#else
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#endif
#if defined(sun) && defined(__svr4__)
#include <sys/systeminfo.h>
#endif

#include "config.h"
#include "net.h"

class SRMv2_IPNetwork : public SRMv2_Network {
public:
	~SRMv2_IPNetwork();
	virtual void reset();
	virtual void sendto(const SRMv2_pktbuf* pb);

	void drop_membership();
	int open(u_int32_t addr, int sport, int rport, int ttl);
	int open(int port);

	int ssock_port();
	int rsock_port();
protected:
	int open(u_int32_t addr, int port, int ttl);
	int close();
	void localname(sockaddr_in*);
	int openssock(u_int32_t addr, u_short port, int ttl);
	int openrsock(u_int32_t addr, u_short port,
		      const struct sockaddr_in& local);
	int add_membership();
	time_t last_reset_;
};

#endif
