/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

/*  
 * Revision: @(#)list.h	1.2        8/24/93     Hui Zhang   
 */
/* Exported functions and macros from list processing module */


#ifndef LIST_INCLUDED
#define LIST_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif
	
#define l_nbr(x) x->prev
#define r_nbr(x) x->next
#define hdofq(q) q->head 
#define	lst_to_obj(x) x->udata
#define	new_lst(q) q =  (pkt_str *) smalloc(sizeof(pkt_str)); 
#define new_lstptr(x) obj_to_lst( (caddr_t) x);

typedef struct lst_str *lstptr;
typedef struct lst_str {
	void    *udata; /* Set to pointer to a SRMv2_pktbuf */
	lstptr	next;
	lstptr	prev;
} lststr;

/* typedef struct pkq_str *pkqptr; */
typedef struct pkq_str {
	lstptr head;
	lstptr tail;
} pkt_str;

#define empty_list(qu) \
    ((qu->head == nil) && (qu->tail == nil))

void 	pop_list(pkt_str *qu);
void 	destroy_entry(lstptr answer);
lstptr 	obj_to_lst(char* pkt);
void 	insert_at_head(lstptr nptr, pkt_str *qu);
void 	insert_at_tail(lstptr nptr, pkt_str *qu);
void 	insert_aftr(lstptr entry, lstptr lnbr, pkt_str *qu);
void 	delete_list(lstptr ptr, pkt_str *qu);
void 	join_lists(pkt_str *qu1, pkt_str *qu2);
void 	init_list(pkt_str *qu);
	
#ifdef __cplusplus
}
#endif

#endif


