# vic-view.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

######
#VicReceiver
# Creates a widget that includes a SessionReceiver for the spec along 
# with session information.
#
Class VicReceiver

VicReceiver instproc init {spec ui} {
    set spec_window [join [split $spec .] /]
    global view_ sr_vic_$spec_window
    $self instvar spec_ ui_
    set spec_ $spec
    set ui_ $ui

    set sr_vic_$spec_window [new SessionReceiver $spec .vic.$spec_window]

    # frame made in SessionReciever init 
    set w .vic.$spec_window
    pack $w -anchor nw

    # basic session information
    frame $w.info -height 60 -width 120 -relief sunken
    label $w.info.address_label -text "Address:"
    label $w.info.address -text "$spec" -relief sunken
    pack $w.info -side left
    pack propagate $w.info false
    pack $w.info.address_label -anchor nw
    pack $w.info.address -anchor c -side top

    bind $w.info <ButtonPress-3> "$self trigger_dropmenu $w"
    bind $w.info.address_label <ButtonPress-3> "$self trigger_dropmenu $w"
    bind $w.info.address <ButtonPress-3> "$self trigger_dropmenu $w"
}

#
# If the right-mouse button is clicked on the session info area, this method
# is called to trigger a drop down menu.
#
VicReceiver instproc trigger_dropmenu {w} {
    $self instvar spec_ ui_ rmsession_dropmenu
    set path $w.rmsession_dropmenu
    if {[winfo exists $path]} {
	tk_popup $rmsession_dropmenu [winfo pointerx $path] \
		[winfo pointery $path]
    } else {
	set rmsession_dropmenu [menu $path -tearoff 0]

	$rmsession_dropmenu add command -label "Session Info"
	$rmsession_dropmenu add command -label "Remove Session" -command \
		"$ui_ remove_session $spec_"

	tk_popup $rmsession_dropmenu [winfo pointerx $path] \
		[winfo pointery $path]
    }
}

