/*
 * ts_fill.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/time.h>
#include "../../../../vd/audio/qm-files.h"
#include <sys/types.h>

int main(int argc, char** argv)
{
  int x;
  FILE* infile;
  FILE* outfile;
  int numPackets;

  struct QMHeader hdr;
  struct QMPacketInfo info;

  u_int32_t firstTs;
  u_int32_t lastTs;

  if(argc != 3)
  {
    fprintf(stderr, "Usage: ts_fill <input filename> <output filename>\n");
    exit(1);
  }

  // FIXME - should check to make sure input and output aren't the same

  infile = fopen(argv[1], "r");

  if(infile == NULL)
  {
    fprintf(stderr, "Unable to open file %s\n", argv[1]);
    exit(1);
  }

  outfile = fopen(argv[2], "w");
  if(outfile == NULL)
  {
    fprintf(stderr, "Unable to open file %s for writing\n", argv[2]);
    fclose(infile);
    exit(1);
  }

  // header
  fread(&hdr, sizeof(struct QMHeader), 1, infile);
  fwrite(&hdr, sizeof(struct QMHeader), 1, outfile);
  printf("numPackets = %d\n", hdr.numPackets);

  numPackets = 0;

  if(hdr.numPackets > 0)
  {
    fread(&info, sizeof(struct QMPacketInfo), 1, infile);
    firstTs = info.ts;
    lastTs = info.ts;
    fwrite(&info, sizeof(struct QMPacketInfo), 1, outfile);
    numPackets++;

//    printf("ts=%u\n", info.ts);
//    printf("\tflags=0x%x\n", info.flags);
//    printf("\tseqno=%u\n", info.seqno);
//    printf("\tindex=%d\n", info.index);
//    printf("\tsysTime=%lu %lu\n", info.sysTime.tv_sec, info.sysTime.tv_usec);
  }

  // packet infos
  for(x = 0; x < hdr.numPackets - 1; ++x)
  {
    fread(&info, sizeof(struct QMPacketInfo), 1, infile);


    // this next part was needed because we had more than one audio source on
    //   the audio channel, which was not good
    // since I didn't record the ssrc, there was no way to know who sent the
    //   audio packet
    // luckily, the timestamps were far apart so I could distinguish packets
    //   from the two sources on that
    /*
    if(info.ts < 100000000)
    {
      printf("\tsmall TS:  ts = %u, lastTs = %u; sysTime=%lu %lu\n", info.ts, lastTs, info.sysTime.tv_sec, info.sysTime.tv_usec);
      // ignore this packet, don't write it out
      continue;
    }
    */

    if(info.ts != lastTs + TS_STEP)
    {
      numPackets += fillInGaps(lastTs + TS_STEP, info.ts - TS_STEP, outfile);
    }

    lastTs = info.ts;
    fwrite(&info, sizeof(struct QMPacketInfo), 1, outfile);
    numPackets++;

//    printf("ts=%u\n", info.ts);
//    printf("\tflags=0x%x\n", info.flags);
//    printf("\tseqno=%u\n", info.seqno);
//    printf("\tindex=%d\n", info.index);
//    printf("\tsysTime=%lu %lu\n", info.sysTime.tv_sec, info.sysTime.tv_usec);
  }

  // write the header back with updated info
  hdr.numPackets = numPackets;
  hdr.postProcessed = 1;
  hdr.firstTs = firstTs;
  hdr.lastTs = lastTs;
  fseek(outfile, 0, SEEK_SET);
  fwrite(&hdr, sizeof(struct QMHeader), 1, outfile);

  fclose(infile);
  fclose(outfile);

  return(0);
}

// fills in from startTs through endTs, inclusive
int fillInGaps(u_int32_t startTs, u_int32_t endTs, FILE* outfile)
{
  u_int32_t ts;
  struct QMPacketInfo info;
  int num = 0;

  for(ts = startTs; ts <= endTs; ts += TS_STEP)
  {
//    printf("adding empty record for %u\n", ts);
    info.ts = ts;
    info.index = -1;  // mark it as invalid
    // index == -1 => rest of struct is garbage, so don't fill in
    fwrite(&info, sizeof(struct QMPacketInfo), 1, outfile);
    num++;
  }
  return(num);
}


