# script-loader.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mplug/script-loader.tcl,v 1.11 2002/02/03 04:27:54 lim Exp $


import WidgetClass
WidgetClass transparent_gif
import MessageBox Configuration ErrorWindow


Class MashScriptLoader

MashScriptLoader proc.public instance { } {
	return [$self set instance_]
}


MashScriptLoader public init { mimetype } {
	MashScriptLoader set instance_ $self
	$self instvar mplug_
	set mplug_ [new MPlug]
	#set http_ [new HTTP]

	set o [new Configuration]
	$self optionsFrom $o
	$o load_preferences "mplug"
	if { ![$self confirm_download] } {
		$self do_error "User decided not to execute script"
	}

	# on success, the following function returns NPRES_DONE which is
	# defined to 0 in a .h file
	# FIXME: how do I pull in constants defined in .h files into tcl?
	if { [$mplug_ wait_for_stream] } {
		puts stderr "Could not retrieve stream"
		exit
	}

	if { [$mplug_ get mimetype] != $mimetype } {
		$self do_error "The loader cannot handle mimetype:\
			[$mplug_ get mimetype]"
	}

	set stream [$mplug_ get stream]
	$self exec $stream
}


MashScriptLoader private exec { stream } {
	uplevel #0 $stream
	vwait forever
}


MashScriptLoader private do_error { msg } {
	$self instvar mplug_
	label .label -text $msg -justify left -anchor w
	pack .label  -fill both -expand 1 -padx 10 -pady 10
	vwait forever
}


MashScriptLoader private confirm_download { } {
	set r [$self get_option mash-script.run_without_asking]
	if { $r == 1 || $r == 0 } { return $r }

	# ask the use before executing the script
	$self instvar mplug_
	ConfirmDownloadDlg .dlg$self -image Icons(warning) -text \
			"\nYou are about to run a MASH script that has\
			\nbeen downloaded from the Web. This is a\
			\npotential security risk.\
			\nDo you want to continue?\n\n"

	set retval [.dlg$self invoke]
	if { [.dlg$self never_ask] } {
		# set a flag in prefs-mplug

        global env
        if {![info exists env(HOME)]} {
		    new ErrorWindow \
		        {Your HOME environment variable must be set.}
            exit 1
        }
	    set mash [file join $env(HOME) .mash]
		if {![file exists $mash]} {
			file mkdir $mash
		}
		set f [open [file join $mash prefs-mplug] a+ 0644]

		set comment "# the run_without_asking flag has the following\
				semantics\
				\n#     1 => always download without asking\
				\n#     0 => never download and run\
				\n#     anything else => prompt the user"
		puts $f "\n${comment}\nmash-script.run_without_asking: 1\n"
		close $f
	}
	destroy .dlg$self

	if { $retval=="yes" } { return 1 } else { return 0 }
}


MashScriptLoader public import { args } {
	$self instvar mplug_ http_

	set url_prefix [$mplug_ get url]
	set end [string length $url_prefix]
	if { [string index $url_prefix [expr $end-1]] != "/" } {
		# strip the tail of the url
		set end [string last "/" $url_prefix]
		set url_prefix [string range $url_prefix 0 $end]
	}

	set list_of_urls {}
	foreach entry $args {
		lappend list_of_urls "${url_prefix}${entry}.mash"
	}

	Dialog transient MessageBox -text "List of urls '$list_of_urls'"
	set retval [$http_ get $list_of_urls]
	if { $retval=={} } {
		# remove anything that might have been created inside .
		# since we have an error
		foreach child [winfo children .] {
			destroy $child
		}

		$self do_error "\nImport error:\n[$http_ error]\n"
	}

	foreach script $retval {
		uplevel #0 $script
	}
}


WidgetClass ConfirmDownloadDlg -superclass MessageBox -default {
	{ .title "Are you sure?" }
	{ *ImageTextButton.borderWidth 1 }
	{ *Label.font WidgetDefault }
	{ *Label.wrapLength 0 }
	{ *Checkbutton.borderWidth 1 }
	{ .type yesno }
}


ConfirmDownloadDlg private build_widget { path } {
	$self next $path
	checkbutton $path.never_ask -anchor w -variable \
			[$self tkvarname never_ask_] -text \
			"Don't ask this question in the future"
	pack $path.never_ask -fill x -side top -anchor w -padx 15 -pady 5
}


ConfirmDownloadDlg public never_ask { } {
	$self tkvar never_ask_
	return $never_ask_
}


#proc import { args } {
#	eval [list [MashScriptLoader instance]] import $args
#}


new MashScriptLoader "x-mash/x-script"

