# main.tcl --
#
#       This is the main entry point for the fca tool.
#       Tcl source code expansion with tcl-expand.tcl starts here.
#       Tcl execution also starts here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
# Put all the tcl files needed for mb here
#

proc havefont { f } { return 1 }

# common files
source tcl/common/util.tcl
source tcl/common/application.tcl

# srm stuff
source tcl/srm/cf-srm.tcl

proc DbgOut {str} {
    puts "$str"
}


proc assert { expression {msg {}} } {
    if { ![uplevel expr $expression] } {
	if { $msg!={} } {
	    error "assert failed for '$expression': $msg"
	} else {
	    error "assert failed for '$expression'"
	}
    }
}


# fca stuff
source tcl/fca/fca-fcp.tcl
source tcl/fca/fca-fcd.tcl
source tcl/fca/fca-mgr.tcl
source tcl/fca/fca-rreq.tcl
source tcl/fca/fca-rcvr.tcl
source tcl/fca/fca-modrcvr.tcl
source tcl/fca/fca-localrcvr.tcl
source tcl/fca/fca-pkt.tcl
source tcl/fca/application-fca.tcl
source tcl/fca/fca-cb.tcl

# ui stuff
source tcl/ui_tools/ui-util.tcl
source tcl/ui_tools/ui-dropdown.tcl
source tcl/ui_tools/ui-minimize.tcl
source tcl/ui_tools/ui-list.tcl
source tcl/ui_tools/ui-book.tcl
source tcl/ui_tools/ui-fonts.tcl
source tcl/ui_tools/images.tcl
source tcl/fca/icons.tcl
source tcl/fca/fca-ui.tcl
source tcl/fca/fca-uimgr.tcl


#
# First procedure to be called from mash
#
# o start up the MediaBoard application
#
proc main argv {
    global FCApp
    set FCApp [new FCApp $argv]
}

ui_init_default
main $argv
