# keepalive.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Class KeepAlive
KeepAlive set BeaconInterval_ms 2000
Class KeepAliveSlave  -superclass KeepAlive
Class KeepAliveMaster -superclass KeepAlive



Class KAChannel -superclass CBChannel/Local
KAChannel set ChannelID_ 1
Class KASChannel -superclass CBChannel/Local
Class KAMChannel -superclass CBChannel/Local



KASChannel instproc init { cb argv0 argv } {
    $self next $cb -id [KAChannel set ChannelID_] -nolisten
    $self set pid_   [pid]
    $self set argv0_ $argv0
    $self set argv_  $argv
}


KASChannel instproc send_alive { } {
    $self instvar pid_ argv0_ argv_
    $self send -apptype KeepAliveMaster alive $pid_ $argv0_ $argv_
}


KASChannel instproc send_dying { } {
    $self instvar pid_
    $self send -apptype KeepAliveMaster dying $pid_
}


KeepAliveSlave instproc init { cb argv0 argv } {
    $self next
    $self instvar cb_ channel_ after_id_
    set cb_ $cb
    set channel_ [$cb_ new_channel KASChannel $argv0 $argv]
    $self send_alive
}


KeepAliveSlave instproc destroy { } {
    $self instvar channel_ cb_ after_id_
    $channel_ send_dying
    $cb_ delete_channel channel_
    after cancel $after_id_
    $self next
}


KeepAliveSlave instproc send_alive { } {
    puts "Sending alive: [pid]"
    $self instvar channel_
    $channel_ send_alive

    # schedule the next alive beacon
    $self set after_id_ [after [KeepAlive set BeaconInterval_ms] \
	    "$self send_alive"]
}


KeepAliveSlave instproc send_dying { } {
    $self instvar channel_
    $channel_ send_dying
}






















KeepAliveMaster instproc init { cb } {
    $self next
    $self instvar cb_ channel_ applist_
    set cb_ $cb
    set channel_ [$cb_ new_channel KAMChannel $self]
    set applist_ ""
    $self periodic_check
}


KeepAliveMaster instproc destroy { } {
    $self instvar channel_ cb_ after_id_
    $cb_ delete_channel channel_
    after cancel $after_id_
    $self next
}




KeepAliveMaster instproc proc_alive { infoVar pid argv0 argv } {
    puts "Alive: $pid $argv0"
    $self instvar apps_ applist_ after_id_
    if { ![info exists apps_($pid,argv0)] } {
	# this is a new application
	$self new_application $pid $argv0 $argv
	lappend applist_ $pid
    }
    set apps_($pid,argv0)  $argv0
    set apps_($pid,argv)   $argv
    set apps_($pid,status) alive
}


KeepAliveMaster instproc proc_dying { infoVar pid } {
    puts "Got dying $pid"
    $self instvar applist_
    if { [lsearch $applist_ $pid]==-1 } { return }
    $self dismiss $pid
    $self remove  $pid
}


KeepAliveMaster instproc periodic_check { } {
    $self instvar apps_ applist_
    puts "Periodic check [clock seconds]"
    foreach pid $applist_ {
	if { $apps_($pid,status)=="no_beacon" } {
	    # I guess this app has died; maybe we should restart it
	    $self restart $pid $apps_($pid,argv0) $apps_($pid,argv)
	    $self remove $pid
	} else {
	    set apps_($pid,status) "no_beacon"
	}
    }
    set after_id_ [after [expr [KeepAlive set BeaconInterval_ms]*2] \
	    "$self periodic_check"]
}


KeepAliveMaster instproc remove { pid } {
    $self instvar apps_ applist_
    set idx [lsearch $applist_ $pid]
    if { $idx==-1 } { return }

    set applist_ [lreplace $applist_ $idx $idx]
    unset apps_($pid,argv0)
    unset apps_($pid,argv)
    unset apps_($pid,status)
}








#virtual methods

KeepAliveMaster instproc new_application { pid argv0 argv } {
}


KeepAliveMaster instproc restart { pid argv0 argv } {
}


KeepAliveMaster instproc dismiss { pid } {
}






KAMChannel instproc init { cb kam } {
    $self next $cb -id [KAChannel set ChannelID_]
    $self register alive "$kam proc_alive"
    $self register dying "$kam proc_dying"
}
