# datasrc-local.tcl --
#
#       DataSrc/Local -- local receiver that knows how to send data
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Class DataSrc/Local -superclass DataSrc

DataSrc/Local instproc init {} {
        $self next
}

# REVIEW: should be possible to put more than one event onto one packet...
DataSrc/Local instproc next_ADU {maxLen} {
        # REVIEW: should for overflowing maxlen

        $self instvar outbox_ events_ outbox_
        set outItem [removeFirst outbox_]
        # for events, append the content of the event
        if {[lindex $outItem 0]=="e"} {
                set eId [lindex $outItem 1]
                return [lappend outItem $events_($eId)]
        } else {
                return $outItem
        }
}

# REVIEW: this should go into a linked list in C++
DataSrc/Local instproc req_send_event {eventId} {
        $self instvar outbox_ atobjRcvr_ events_
        lappend outbox_ [list e $eventId]
        $atobjRcvr_ begin_xmit [expr \
                        [string length $events_($eventId)] + 6 \
                        + [string length $eventId] ]
}

DataSrc/Local instproc req_sent_ctrl {ctrlMsg} {
        $self instvar outbox_ atobjRcvr_
        set m [list c $ctrlMsg]
        set l [string length $m]
        lappend outbox_ $m
        $atobjRcvr_ begin_xmit $l
}

# gives the source a chance to send out any data...
DataSrc/Local instproc setup {} {
}

# this procedure provides the loopback + outflow to network that we need
DataSrc/Local instproc handle {eId event} {
#        DbgOut "handle: $event, eId: $eId"
        $self req_send_event $eId

        # this sends the data up to the view
        $self next $eId $event
}

DataSrc/Local instproc advance {time} {
        $self instvar view_
        # advance first
        $self next $time
        $view_ update $time
        set min [$view_ oldestEId]
        set max [$view_ newestEId]

        $self req_sent_ctrl [list r $time $min $max]
        DbgOut req_sent-ctrl r $min $max $time
}

