# atobj-rcvr.tcl --
#
#       AtObjRcvr : Active Object Receiver
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#---------------------------------------------------------------------------
# AtObjRcvr --
#
#         An active object receiver is the class that handles the
#         active objects streams from a end host (i.e. SRM_Source).
#         It handles the demultiplexing of streams into each active object.
#

Atobj_rcvr instproc new_animation {anmName} {
        # REVIEW: figure out dynamic creation of objects with diff. types
        set anmType Nam
        set anmView [new AnmView/$anmType]
        DbgOut "created anmView: $anmView"
        set datasrc [new DataSrc/$anmType]
        DbgOut "created datasrc: $datasrc"
        $anmView attach_datasrc $datasrc
        $datasrc attach_view $anmView
        $datasrc attach_rcvr $self
        $datasrc setAnmId $anmName

        # should have font and text events....
        $anmView setFontByIdx 0 "lucidasanstypewriter-10" Blue
        $anmView setFontByIdx 1 \
                        "-adobe-helvetica-bold-r-normal--12-*-*-*-*-*-*-*" \
                        Brown

        set host [info hostname]
        wm title [$anmView path] "(Remote) Nam@$host"
        $self attach_info $anmView $datasrc
        $datasrc setup
        return $datasrc
}

#
# REVIEW: should have a more generic UI for remote ....
#         maybe something closer to that of NamUI....
#
Atobj_rcvr instproc attach_info {view datasrc} {
        set p [$view path]
        set f [frame $p.ff -relief ridge]
        set l [button $p.f -text "time:" -relief flat \
                        -activebackground [lindex \
                        [$f configure -background] 4] \
                        -command "new StackTrace {}"]
        set lt [label $p.lt -text "0.0"]
        set bq [button $p.bq -text "Quit" -command exit]
        pack $f -side bottom -fill x
        pack $l $lt -expand false -fill x  -side left
        pack $bq -side right -expand false -fill x

        $datasrc proc hook_updateTime {t} " \
                        $lt configure -text  \[format %.4f \$t\] \
        "

        set vpath [$view path]
        bind $vpath <q> exit
        bind $vpath <Control-c> exit
}
