# mb-play.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import ArchiveSession/Play SRMAgent AddressBlock

# Currently, all code for SRM archival is mediaboard-specific, and resides
# in the ArchiveSession/Play/Mediaboard class. Eventually, with the new
# SRMv1, this functionality will be moved to the ArchiveSession/Play/SRM
# class, where it rightfully belongs.
#
# This class implements the player session object for playing back SRM
# sessions. It encapsulates the creation and manipulation of SRM session
# objects and state.  Note: This class currently supports only mediaboard
# sessions.
# Status: beta
# Author: Yatin Chawathe

Class ArchiveSession/Play/Mediaboard \
		-superclass {ArchiveSession/Play MB_Manager/Play}
Class ArchiveSession/Play/SRM -superclass ArchiveSession/Play/Mediaboard

# Syntax: set session [new ArchiveSession/Play/SRM <media> <addr>]
# The init method creates a new SRM session, initializes the network
# and creates a source manager object for the session.
ArchiveSession/Play/Mediaboard instproc init { media addr } {
	$self next

        ArchiveSession/Play/Mediaboard instvar count_
	if ![info exists count_] {
		set count_ 1
	}

	$self set stream_list_ ""
	$self create_session $addr
	$self media $media
}

ArchiveSession/Play/Mediaboard instproc destroy {} {
	$self instvar agent_ stream_list_

	foreach stream $stream_list_ {
		delete $stream
	}

	delete $agent_
	$self next
}

ArchiveSession/Play/Mediaboard instproc create_session { addr \
		{src_update_handler {}} } {
	$self instvar session_ agent_

        set agent_ [new SRMAgent]
	set session_ [$agent_ create-session $self $src_update_handler]

	# set the default_local_ variable, so that the "reset" method
	# does not automatically create a local source object
	$agent_ set default_local_ ""

	$self reset $addr
	$self attach_session $session_
}


ArchiveSession/Play/Mediaboard instproc reset { addr } {
	$self instvar session_ agent_
	set had_network [$agent_ have_network]
	set ab [new AddressBlock $addr]
	$agent_ reset $ab
	delete $ab
	set net [$agent_ set network_]
	[$net data-net] loopback 1
	[$net ctrl-net] loopback 1

        # do this for the first time only
	if !$had_network {
		$session_ start_timers
	}
}

# Accessor method to access the SRM session object inside the playback
# session object. Returns: The name of the SRM session object associated
# with this session.
ArchiveSession/Play/Mediaboard instproc srm_session { } {
	return [$self set session_]
}

# Accessor method to access the SRM source manager object inside the playback
# session object. Returns: The name of the SRM source manager object associated
# with this session.
ArchiveSession/Play/Mediaboard instproc srm_source_mgr { } {
	return [$self set agent_]
}





ArchiveSession/Play/Mediaboard instproc source_id { original uidVar addrVar } {
	upvar $uidVar uid $addrVar addr
	$self instvar agent_

	# set original [split $original @]
	# set uid "0x[lindex $original 0]"
	# set uid [expr ($uid << 16) | 0x[$agent_ default-local-uid]]
	# set uid [format "%x" $uid]

	ArchiveSession/Play/Mediaboard instvar count_
	set uid 0x[$agent_ default-local-uid]
	puts "uid: $uid count: $count_"
	set uid [expr ($uid << 16) | $count_]
	set uid [format "%x" $uid]
	incr count_
	puts "uid: $uid count: $count_"

	# set the addr to {}, since SRM will choose the default automatically
	set addr {}
}

# Creates an SRM source object to be associated with this stream.
# Initializes the user name for this SRM source by appending the string
# "(recorded)" to the end of the original user name stored in the stream
# data file.
ArchiveSession/Play/Mediaboard instproc attach_stream { stream } {
	set datafile [$stream datafile]
	if { $datafile=={} } {
		error "no data file associated with stream"
	}

	$datafile header hdr
	$self instvar stream_list_
	lappend stream_list_ $stream
	$self source_id $hdr(cname) uid addr

	if {[string first "(rec)" $hdr(name)] == -1} {
		set hdr(name) "(rec) $hdr(name)"
	}
	$self create_srm_source $stream $uid $addr $hdr(name)
}


# Create and return a new mediaboard stream object.   The object's class
# is ArchiveStream/Play/Mediaboard
ArchiveSession/Play/Mediaboard instproc create_stream { } {
	return [new ArchiveStream/Play/Mediaboard]
}
