# ui-srvalloc.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/uc/ui-srvalloc.tcl,v 1.7 2002/02/03 04:22:33 lim Exp $


import Trace CheckButton Observer RendezvousManager
#Trace on ; Trace add SrvAllocUI

# class that observes msgs on the rendezvous channel indicating
# new services are available that can be allocated, and presents
# a dynamic list of them to the user allowing him or her to choose
# which ones to actually request.
#
Class SrvAllocUI -superclass Observer


#
# FIXME need to ask rv_ for all previous "can-allocate" msgs to avoid
# startup delay
#
SrvAllocUI public init {w spec} {
    Trc $class "--> ${class}::$proc"
    $self next

    $self init_network $spec
    $self init_gui $w
    $self update_gui
}

#
SrvAllocUI public destroy {} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_ req_msgs_
    # stop any rv msgs
    foreach r [array names req_msgs_] {
	foreach m $req_msgs_($r) {
	    catch {$rv_ stop $r $m}
	}
    }
    $rv_ detach_observer $self
    $self next
}


#
SrvAllocUI private init_network {spec} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_

    foreach rv [RendezvousManager info instances] {
	if {[lsearch -exact [$rv get_specs] $spec] != -1} {
	    set rv_ $rv
	}
    }
    if ![info exists rv_] {
	set rv_ [new RendezvousManager $spec]
    }
    $rv_ attach_observer $self
}

#
SrvAllocUI private parse_components {rvmsg} {
    Trc $class "--> ${class}::$proc [$rvmsg data]"
    $self instvar components_
    set uid [$rvmsg get_field uniqid]
    set rspec [$rvmsg rspec]

    # only add components once
    if {[array names components_ $rspec] == "" || \
	    [lsearch -exact $components_($rspec) $uid] == -1} {
	lappend components_($rspec) $uid
    }
    #parray components_
}


#
SrvAllocUI private init_gui {w} {
    Trc $class "--> ${class}::$proc"
    $self instvar components_ w_
    set w_ $w

    # bottom informational label
    set il $w.infolabel
    frame $il -relief groove
    label $il.l -text "Service Allocator"
    pack $il -side bottom -fill x -expand 1
    pack $il.l -in $il -side bottom

    # srvs frame
    frame $w.listFrame -relief groove
    pack $w.listFrame -side left -fill y -expand 1
}

#
SrvAllocUI private update_gui {} {
    Trc $class "--> ${class}::$proc"
    $self instvar w_ components_ cb_ rv_
    set w $w_
    set need_repack 0

    set rspecCnt 0
    foreach rspec [array names components_] {
	# create/edit the label associated -w- each rspec
	set l $w.listFrame.l$rspecCnt
	if {[info commands $l] == ""} {
	    label $l -text "Scope: [$rv_ get_spec_name $rspec]"
	} else {
	    $l configure -text "Scope: [$rv_ get_spec_name $rspec]"
	}

	# under each rspec, create/edit checkbutton per srv
	set count 0
	foreach uid $components_($rspec) {
	    set cbpath $w.listFrame.cb${rspecCnt}-$count

	    set msg [$rv_ query "can-allocate: & uniqid=$uid"]
	    set ob [$msg get_field mash-object]
	    if {$ob == ""} {
		set ob [$msg get_field WPI]
		set ob "WPI:[lindex [split $ob /] end]"
	    }
	    set sname "$ob:"
	    append sname [$msg get_field name]

	    if {[info commands $cbpath] == ""} {
		set need_repack 1
		set cb_($cbpath) [new CheckButton $cbpath -padx 12 \
			-text "$sname" \
			-command "$self checkButtonInvoke $rspec $uid $cbpath"]
	    } else {
		$cbpath configure -text "$sname" \
			-command "$self checkButtonInvoke $rspec $uid $cbpath"
	    }
	    incr count
	}
	incr rspecCnt
    }

    # if we added any widgets, repack
    if $need_repack {
	foreach i [info commands $w.listFrame.*] {
	    pack forget $i
	}
	set rspecCnt 0
	foreach rspec "[array names components_]" {
	    pack $w.listFrame.l$rspecCnt -side top -anchor w
	    set count 0
	    foreach sname $components_($rspec) {
		pack $w.listFrame.cb${rspecCnt}-$count -anchor w
		incr count
	    }
	    incr rspecCnt
	}
    }
}

#
SrvAllocUI private checkButtonInvoke {rspec uid cbpath} {
    Trc $class "--> ${class}::$proc"
    $self instvar cb_

    set cb $cb_($cbpath)
    if [$cb get_val] {
	$self start_requesting $rspec $uid
    } else {
	$self stop_requesting $rspec $uid
    }
}


# -------------------------------------------------------------
# Methods for dealing with a RendezvousManager and its upcalls
# --------------------------------------------------------------


#
SrvAllocUI private start_requesting {rspec uid} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_ req_msgs_
    set m "allocate: uniqid=$uid"
    $rv_ start $rspec $m
    lappend req_msgs_($rspec) $m
}

#
SrvAllocUI private stop_requesting {rspec uid} {
    Trc $class "--> ${class}::$proc"
    $self instvar rv_
    $rv_ stop $rspec "allocate: uniqid=$uid"
}


# our main cause of action -- a servent has been found
# that can be allocated by the user.
SrvAllocUI public rendez_recv_can-allocate {rvmsg} {
    Trc $class "--> ${class}::$proc"
    $self parse_components $rvmsg
    $self update_gui
}

# this upcall is useful only to update labels in the GUI
SrvAllocUI public rendez_recv_scope {rvmsg} {
    $self update_gui
}

