# app-player.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/player/app-player.tcl,v 1.10 2002/02/03 04:22:14 lim Exp $


import Application FileDialog/Archive PlayerUI/EditStream PlayerUI/Main ArchiveSession/Play/RTP ArchiveSession/Play/SRM

#  This class implements policy for the player application
#  <p> Status: Beta


Class Application/Player -superclass Application


Application/Player instproc init { } {
	$self next player
	#$self instvar options_
	set options_ [$self options]
	$self init_resources $options_
	$class set instance_ $self

    # Hide the root window offscreen so it's not visible.  We can't just
    # withdraw or iconify it because, on Windows, that will also
    # withdraw/iconify all the transient windows used as dialogs.
    # Unfortunately, we have to force a window update and then reposition it
    # offscreen because some Unix window managers adjust the positions of
    # windows when they first appear.
    #
    label .label -text {Starting up...}
    pack .label -fill both -expand true
    set x [expr int([winfo screenwidth .] / 2)]
    set y [expr int([winfo screenheight .] / 2)]
    wm geometry . +$x+$y
    update idletasks
    .label configure -text {Running...}
    set x [expr [winfo screenwidth .] + 32]
    set y [expr [winfo screenheight .] + 32]
    wm geometry . +$x+$y

	$self set file_dialog_ [FileDialog/Archive .file_dialog \
			-transient . ]
	$self set edit_stream_dialog_ [PlayerUI/EditStream .edit_stream_dialog\
			-transient . ]
	$self set main_ui_ [PlayerUI/Main .player_ui \
			-closecmd "delete $self; exit"]
}


Application/Player instproc init_resources o {
        $o add_default drop 0
        $o add_default debug 0
        $o add_default rtPlay 0
        $o add_default record 0
        $o add_default uid none
        $o add_default trace none
        $o add_default delayParams default

	$o add_default defaultTTL 31
}


Application/Player instproc destroy { } {
	$self instvar file_dialog_ main_ui_
	if [info exists file_dialog_] { destroy $file_dialog_ }
	if [info exists main_ui_] { destroy $main_ui_ }
}


Application/Player proc instance { } {
	return [$self set instance_]
}


Application/Player instproc file_dialog { } {
	return [$self set file_dialog_]
}


Application/Player instproc edit_stream_dialog { } {
	return [$self set edit_stream_dialog_]
}


Application/Player instproc lts { } {
	return [$self set lts_]
}


Application/Player instproc main_ui { } {
	return [$self set main_ui_]
}


Application/Player instproc parse_args { argv } {
	$self instvar no_input_ main_ui_
	set no_input_ 0

	set len [llength $argv]
	set idx 0
	while { $idx < $len } {
		set option [lindex $argv $idx]
		incr idx
		switch -exact -- $option {
			-catalog {
				if { $idx >= $len } {
					error "missing argument for\
							-catalog"
				}
				$main_ui_ read_catalog \
						[lindex $argv $idx]
				incr idx
			}

			-addsession {
				if { $idx >= $len } {
					error "missing argument for\
							-addsession"
				}
				set arg [lindex $argv $idx]
				if { [llength $arg] != 3 } {
					error "invalid argument to\
							-addsession: $arg.\
							must be	\"<protocol>\
							<media> <addr>\""
				}
				$main_ui_ add_session [lindex $arg 0] \
						[lindex $arg 1] [lindex $arg 2]
				incr idx
			}

			-addstream {
				if { $idx >= $len } {
					error "missing argument for\
							-addstream"
				}
				set arg [lindex $argv $idx]
				if { [llength $arg] != 2 } {
					error "invalid argument to\
							-addstream: $arg.\
							must be	\"<datafile>\
							<indexfile>\""
				}

				eval [list $self] add_stream $arg
				incr idx
			}

			-noinput {
				set no_input_ 1
			}

			default {
				$self usage
			}
		}
	}
}


Application/Player instproc add_stream { datafile indexfile } {
	set file [new ArchiveFile]

	if [catch {$file open $datafile} error] {
		error "Error opening data file:\n$error"
	}

	if [catch {$file header data_hdr} error] {
		error "Error reading data header:\n$error"
	}

	$file close


	if [catch {$file open $indexfile} error] {
		error "Error opening index file:\n$error"
	}

	if [catch {$file header index_hdr} error] {
		error "Error reading data header:\n$error"
	}

	$file close


	if { $data_hdr(protocol)!=$index_hdr(protocol) } {
		error "Protocol fields do not match in data and index files"
	}

	if { $data_hdr(media)!=$index_hdr(media) } {
		error "Media fields do not match in data and index files"
	}

	if { $data_hdr(cname)!=$index_hdr(cname) } {
		error "cname fields do not match in data and index files"
	}

	if { $data_hdr(name)!=$index_hdr(name) } {
		error "Name fields do not match in data and index files"
	}

	delete $file
	$self instvar main_ui_
	$main_ui_ add_stream $data_hdr(name) $datafile $indexfile \
			$data_hdr(protocol) $data_hdr(media)
}



Application/Player instproc usage { } {
	puts "Usage: player \[options\]"
	puts "\t-catalog <file>: read session information from session catalog"
	puts "\t                    (this flag erases any previous sessions"
	puts "\t                    added using -addsession/-addstream)"
	puts "\t-addsession \"<protocol> <media> <address>\": add this session"
	puts "\t                                       to the play list"
	puts "\t\t\t<protocol>: SRM or RTP"
	puts "\t\t\t<media>:    mediaboard, video, audio, etc."
	puts "\t\t\t<address>:  <multicast group>/<port number>"
	puts "\t-addstream \"<datafile> <indexfile>\": add this stream to the"
	puts "\t                                       play list"
	puts "\t-noinput: do not pop up the initial input dialog\n"

	exit
}


Application/Player instproc run { } {
	$self instvar main_ui_ no_input_
	$main_ui_ center
	if { ! $no_input_ } {
		tkwait variable [$main_ui_ tkvarname input_done_]
	}
	$self start_play
	return 1
}


Application/Player instproc start_play { } {
	$self instvar main_ui_ start_ end_ lts_
	set start_ 0
	set end_ 0
	$main_ui_ playback_ui

	set list [$main_ui_ subwidget session_list]
	set lts_ [new LTS]
	set ttl  [$main_ui_ set ttl_]
	foreach session_widget [$list info all] {
		set item_widget [$list info widget -id $session_widget]
		set value [$item_widget cget -value]
		set protocol [string trim [lindex $value 0]]
		set media    [string trim [lindex $value 1]]
		set address  "[string trim [lindex $value 2]]/none/$ttl"

		set session [new ArchiveSession/Play/$protocol $media \
				$address]
		$session attach_observer $session_widget
		$session_widget attach_session $session
	}

	$main_ui_ config_scale $start_ $end_
	$lts_ now_logical $start_
	$lts_ speed 1.0
}


Application/Player instproc clip_time { start end } {
	$self instvar start_ end_
	if { $start_==0 || $start < $start_ } {
		set start_ $start
	}
	if { $end_==0 || $end > $end_ } {
		set end_ $end
	}
}

