# ui-mb.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-mb.tcl,v 1.4 2002/02/03 04:21:46 lim Exp $


#
UISource/Mb public build_widget { path } {
	$self tkvar track_
	$self instvar observer_
	$path configure -command "tk_popup $path.menu \[winfo pointerx $path\]\
			\[winfo pointery $path\]"

	set track_ 0

	menu $path.menu
	$path.menu add checkbutton -label "Track this source" \
			-variable [$self tkvarname track_] -command \
			"$observer_ toggle_track_button $self"
}


UISource/Mb public toggle_track { } {
	$self tkvar track_
	if $track_ { set track_ 0 } else { set track_ 1 }
	return $track_
}


#
Observer/Mb public init { sm srclist } {
	$self next
	$self instvar sm_ srclist_
	set sm_ $sm
	set srclist_ $srclist
	$srclist attach_observer $self
}


Observer/Mb public toggle_track_button { uisrc } {
	# toggle_track will make a callback to us and toggle uisrc once again
	# to ensure that we end up in a sane state, we have to toggle ourselves
	# explicitly here
	$self instvar srclist_
	$uisrc toggle_track
	$srclist_ toggle_track [$uisrc src]
}


Observer/Mb public toggle_track { src } {
	$self instvar msrcs_ currentTrack_
	if ![info exists msrcs_($src)] return
	set uisrc [$msrcs_($src) get_uisource mb $src]

	if { [info exists currentTrack_] && $currentTrack_ != $uisrc } {
		$currentTrack_ toggle_track
	}

	if ![$uisrc toggle_track] { unset currentTrack_ } \
			else { set currentTrack_ $uisrc }
}


#
Observer/Mb private create_multi_source { src } {
	$self instvar sm_ msrcs_

	set sid [split [$src srcid] @]
	# convert the address to x.x.x.x format
	set addr [expr 0x[lindex $sid 1]]
	set addr [binary format I $addr]
	binary scan $addr cccc a1 a2 a3 a4
	foreach a {a1 a2 a3 a4} {
		# convert from signed to unsigned
		set val [set $a]
		set val [expr ($val + 0x100) % 0x100]
		set $a $val
	}

	set cname "[expr 0x[lindex $sid 0]]@$a4.$a3.$a2.$a1"
	set msrcs_($src) [$sm_ register mb $src $cname $self]
	set uisrc [$msrcs_($src) get_uisource mb $src]
	$src set mb_hack_cname_ $cname

	$self update_src_info $src $cname
}


#
# Register a src in the src display.  This happens for all the
# srcs participating in the conferencing (e.g., including
# those not actually sending data).
#
Observer/Mb public register { src } {
	$self create_multi_source $src
}


#
# Remove a src from the src display.  This happens when
# a party quits or has been dead for a sufficiently long time.
# We assume the src has already been deactivated.
#
Observer/Mb public unregister { src } {
}


#
# hilit the source
#    - sets a timeout to unhilit the receiver and execute $command then
#
Observer/Mb public hilit {src} {
	$self instvar msrcs_ id_
	if [info exists id_($src)] {
		after cancel $id_($src)
	} else {
		set uisrc [$msrcs_($src) get_uisource mb $src]
		$uisrc highlight 1
	}

	set id_($src) [after 500 "$self unhilit $src"]
}


Observer/Mb public unhilit {src} {
	$self instvar msrcs_ id_
	if [info exists msrcs_($src)] {
		set uisrc [$msrcs_($src) get_uisource mb $src]
		$uisrc highlight 0
	}
	unset id_($src)
}


# change the name of a source
Observer/Mb public update_src_info {src name} {
	$self instvar msrcs_
	if { [info exists msrcs_($src)] && [$msrcs_($src) name] != $name } {
		set uisrc [$msrcs_($src) get_uisource mb $src]
		$msrcs_($src) change_name $uisrc $name
		$src set mb_hack_name_ $name
	}
}
