/*
 * source-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srmv2_source_h
#define srmv2_source_h

#include "tclcl.h"
#include "inet.h"
#include "srmv2.h"
#include "pktbuf-srmv2.h"
#include "net.h"
#include "transmitter.h"

class NameMap;
class SRMv2_Session;
class SRMv2_RReq;
class adubuf;

class SRMv2_Source : public TclObject {
public:
	SRMv2_Source(const char *src_name);
	SRMv2_Source(const int *src_id);
	~SRMv2_Source();

	int command(int argc, const char*const* argv);
	int  source_id(int idx)    { return sid_[idx]; }
	int* source_id() { return sid_; }
	NameMap *namemap() { return namemap_; }
	unsigned int ipaddr() { return ipaddr_; }
	void ipaddr(unsigned int addr) { ipaddr_ = addr; }

private:
	int* sid_;
	NameMap* namemap_;
	SRMv2_Session* session_;
	unsigned int ipaddr_;   /* IPv4 address */
};
#endif

