/*
 * config.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/rtp/config.h,v 1.15 2002/02/03 04:15:47 lim Exp $
 */

#ifndef mash_config_h
#define mash_config_h

#if defined(sgi) || defined(__bsdi__) || defined(__FreeBSD__)
#   include <sys/types.h>
#elif defined(linux)
#   include <sys/bitypes.h>
#else
#   ifdef ultrix
#       include <sys/types.h>
#   endif
/*FIXME*/
#   ifdef sco
        typedef char int8_t;
#   else
#       if !defined(sun)
            typedef signed char int8_t;
#       endif
#   endif
    typedef unsigned char u_int8_t;
#   if !defined(sun)
        typedef short int16_t;
#   endif
    typedef unsigned short u_int16_t;
    typedef unsigned int u_int32_t;
#   if !defined(sun)
        typedef int int32_t;
#   endif
#endif

#if defined(sun) && !defined(bzero)
#define bzero(dest,count) memset(dest,0,count)
#endif
#if defined(sun) && !defined(bcopy)
#define bcopy(src,dest,size) memcpy(dest,src,size)
#endif

#include <stdlib.h>
#include <time.h>		/* For clock_t */

#ifndef WIN32
#   include <unistd.h>
#   if defined(__cplusplus)
        extern "C" {
#   endif

#   include <netinet/in.h>
#   include <arpa/inet.h>
#   include <string.h>
    clock_t clock(void);

#   if !defined(sco) && !defined(sgi) && !defined(__bsdi__) && !defined(__FreeBSD__) && !defined(__linux__) && !defined(sun)
        int gethostid(void);
#   endif

    time_t time(time_t *);
    char *ctime(const time_t *);
#   if defined(__cplusplus)
        }
#   endif
#endif /* !win32 */

#if defined(NEED_SUNOS_PROTOS)
#if defined(__cplusplus)
    extern "C" {
#endif
struct timeval;
struct timezone;
struct msghdr;
struct sockaddr;
int bind(int s, struct sockaddr*, int);
int close(int);
int connect(int s, struct sockaddr*, int);
int gethostid();
int gethostname(char*, int);
int getpid();
int getsockname(int, struct sockaddr*, int*);
int gettimeofday(struct timeval*, struct timezone*);
int ioctl(int fd, int request, ...);
int recv(int, void*, int len, int flags);
int recvfrom(int, void*, int len, int flags, struct sockaddr*, int*);
int send(int s, void*, int len, int flags);
int sendmsg(int, struct msghdr*, int);
int setsockopt(int s, int level, int optname, void* optval, int optlen);
int socket(int, int, int);
int strcasecmp(const char*, const char*);
#if defined(__cplusplus)
    }
#endif
#endif /* NEED_SUNOS_PROTOS */

#ifdef WIN32

#include <windows.h>
#include <winsock.h>

#define MAXHOSTNAMELEN	256

#define _SYS_NMLN	9
struct utsname {
	char sysname[_SYS_NMLN];
	char nodename[_SYS_NMLN];
	char release[_SYS_NMLN];
	char version[_SYS_NMLN];
	char machine[_SYS_NMLN];
};

typedef char *caddr_t;

struct iovec {
	caddr_t iov_base;
	int	    iov_len;
};

#ifndef TIMEZONE_DEFINED_
#define TIMEZONE_DEFINED_
struct timezone {
	int tz_minuteswest;
	int tz_dsttime;
};
#endif /* ! TIMEZONE_DEFINED_ */

typedef int pid_t;
typedef int uid_t;
typedef int gid_t;

#if defined(__cplusplus)
extern "C" {
#endif

int uname(struct utsname *);
int getopt(int, char * const *, const char *);
int strcasecmp(const char *, const char *);
int srandom(int);
int random(void);
int gettimeofday(struct timeval *p, struct timezone *z);
int gethostid(void);
int getuid(void);
int getgid(void);
int nice(int);
int sendmsg(int, struct msghdr*, int);

#include <process.h>

#define bzero(dest,count) memset(dest,0,count)
#define bcopy(src,dest,size) memcpy(dest,src,size)
#if defined(__cplusplus)
}
#endif /* WIN32 */

#ifdef sgi
#include <math.h>
#endif

#define ECONNREFUSED	WSAECONNREFUSED
#define ENETUNREACH	WSAENETUNREACH
#define EHOSTUNREACH	WSAEHOSTUNREACH
#define EWOULDBLOCK	WSAEWOULDBLOCK

#define M_PI		3.14159265358979323846

#endif /* WIN32 */

#endif
