/*
 * rep-decoder.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "rep-decoder.h"

RepDecoder::RepDecoder(int hdrlen)
  : PacketHandler(hdrlen),
    inw_(0), inh_(0),
    callback_(0),
    delay_flag_(0)
{
}

RepDecoder::~RepDecoder()
{
  pktbuf *pb;
  pb = delay_q_.get_next();
  while (pb != 0) {
    pb->release();
    pb = delay_q_.get_next();
  }

  if (callback_ != 0) {
    free(callback_);
  }
};

void
RepDecoder::recv(pktbuf *pb)
{
  if (delay_flag_) {
    delay_q_.insert(pb);
    return;
  }
  post_delay_recv(pb);
}

int
RepDecoder::command(int argc, const char*const* argv) {
  if (argc == 3) {
    if (strcmp(argv[1], "set_frame_buffer") == 0) {
      VidRep *fb;
      fb = (VidRep *)TclObject::lookup(argv[2]);
      set_frame_buffer(fb);
      return TCL_OK;
    }
   if (strcmp(argv[1], "set_callback") == 0) {
      if (callback_ != 0) {
	free(callback_);
	callback_ = 0;
      }
      if (strlen(argv[2]) > 0) {
	callback_ = (char *) malloc(strlen(argv[2])+1);
	strcpy(callback_, argv[2]);
      }
      return TCL_OK;
    }
  } else if (argc == 2) {
    if (strcmp(argv[1], "delay_on") == 0) {
      delay_flag_ = 1;
      return TCL_OK;
    }
    if (strcmp(argv[1], "delay_off") == 0) {
      pktbuf *pb;
      delay_flag_ = 0;
      pb = delay_q_.get_next();
      while (pb != 0) {
	post_delay_recv(pb);
	pb = delay_q_.get_next();
      }
      return TCL_OK;
    }
  }
  return (PacketHandler::command(argc, argv));
}

double RepDecoder::gettimeofday()
{
  timeval tv;
  ::gettimeofday(&tv, 0);
  return (1e6 * double(tv.tv_sec) + double(tv.tv_usec));
}
