/*
 * mplug-win32.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/win32/mplug-win32.h,v 1.5 2002/02/03 04:13:10 lim Exp $
 */

#ifndef MASH_MPLUG_WIN32_H
#define MASH_MPLUG_WIN32_H


#include "../mplug.h"


#define TK_CLAIMFOCUS     (WM_USER)
#define TK_GEOMETRYREQ    (WM_USER+1)
#define TK_ATTACHWINDOW   (WM_USER+2)
#define TK_DETACHWINDOW   (WM_USER+3)


// there is a bug in netscape (at least under Unix) where it doesn't seem
// to call the plugin's NPP_SetWindow procedure when the main window is
// resized
#define NETSCAPE_RESIZE_BUG 1


// define platform-specific features in a sub-class

class Win32MPlugInstance : public MPlugInstance {
public:
	Win32MPlugInstance(NPMIMEType mimeType, NPP instance, uint16 mode,
			   int16 argc, const char *const *argn,
			   const char *const *argv);
	~Win32MPlugInstance();

	NPError NewWindow(NPWindow *npWindow);
	NPError ReconfigureWindow(NPWindow *npWindow);
	NPError DeleteWindow();

	const char *GetDisplay(NPWindow* /*npWindow*/) { return NULL; }
	unsigned long GetWindowHandle() { return (unsigned long) window_; }

private:
	static LRESULT CALLBACK WindowProc_Static(HWND hWnd, UINT msg,
						  WPARAM wParam,LPARAM lParam);
	LRESULT WindowProc(UINT msg, WPARAM wParam, LPARAM lParam);

	HWND window_, childWindow_;
	WNDPROC defaultWindowProc_;

#ifdef NETSCAPE_RESIZE_BUG
	static LRESULT CALLBACK ParentWindowProc_Static(HWND hWnd, UINT msg,
							WPARAM wParam,
							LPARAM lParam);
	LRESULT ParentWindowProc(UINT msg, WPARAM wParam, LPARAM lParam);

	HWND parentWindow_;
	WNDPROC parentWindowProc_;
#endif

	static const char *instanceLookupString_;
};


#endif /* #ifdef MASH_MPLUG_WIN32_H */
