/*
 * tkPS.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/tkPS.cc,v 1.10 2002/02/03 03:16:30 lim Exp $";
#endif

#ifndef MASH_TKPS_CC
#define MASH_TKPS_CC

#include "tclcl.h"
#include <time.h>
#ifndef WIN32
#include <unistd.h>
#include <pwd.h>
#include <sys/time.h>
#endif

/*
 *--------------------------------------------------------------
 *
 * TkPSHeaderCmd --
 *
 *	Dump the postscript prolog suitable for canvas printouts
 *      into a channel.
 *
 * Results:
 *	A standard Tcl Result.  If everything is OK the prolog
 *	will be written into the channel.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */
int TkCanvPSHeaderCmd(ClientData, Tcl_Interp* interp, int argc, char** argv)
{
        char* channelName = NULL;
        char* title = "no title";
        Tcl_Channel chan;
        if (argc!=3) {
                Tcl_AddErrorInfo(interp, "wrong arguments: " \
                                 "should be MB_ps_hdr <channelName> <title>");
                return TCL_ERROR;
        }
        channelName = argv[1];
        int mode;
        chan = Tcl_GetChannel(interp, channelName, &mode);
        if (chan == (Tcl_Channel) NULL) {
                Tcl_AppendResult(interp, "channel ", channelName,
                                 " not found", (char*) NULL);
                return TCL_ERROR;
        }
        if ((mode & TCL_WRITABLE)==0) {
                Tcl_AppendResult(interp, "channel \"",
                                 channelName, "\" wasn't opened for writing",
                                 (char*)NULL);
                return TCL_ERROR;
        }
        title = argv[2];

        Tcl_ResetResult(interp);
        Tcl_AppendResult(interp, "%!PS-Adobe-3.0 EPSF-3.0\n",
                         "%%Creator: MASH \n", (char *) NULL);

#if !(defined(__WIN32__) || defined(MAC_TCL))
        struct passwd *pwPtr;
        pwPtr = getpwuid(getuid());
        Tcl_AppendResult(interp, "%%For: ",
                         (pwPtr != NULL) ? pwPtr->pw_gecos : "Unknown", "\n",
                         (char *) NULL);
        endpwent();
#endif /* __WIN32__ || MAC_TCL */
        Tcl_AppendResult(interp, "%%Title: ", title, "\n", (char *) NULL);
        time_t now;
        time(&now);
        Tcl_AppendResult(interp, "%%CreationDate: ",
                         ctime(&now), (char *) NULL);

        Tcl_AppendResult(interp, "%%Pages: (atend)\n",
                         "%%DocumentData: Clean7Bit\n", (char *) NULL);
        Tcl_AppendResult(interp, "%%EndComments\n\n", (char *) NULL);

        Tcl_Write(chan, interp->result, -1);
        Tcl_ResetResult(interp);

        /* dump the prolog */
        extern EmbeddedTcl et_tk_prolog;
        Tcl_Write(chan, (char*)et_tk_prolog.get_code(), -1);

        return TCL_OK;
}



/*
 *--------------------------------------------------------------
 *
 * PostscriptPrologCmd --
 *
 *	Dumps the postscript prolog.ps file into the tcl
 *      result variable
 *
 *--------------------------------------------------------------
 */
int PostscriptPrologCmd(ClientData, Tcl_Interp* interp,
                        int /* argc */, char** /* argv */)
{
        /* dump the prolog */
        extern EmbeddedTcl et_tk_prolog;
        Tcl_SetResult(interp, (char*)et_tk_prolog.get_code(), TCL_STATIC);
	return TCL_OK;
}


#endif /* #ifdef MASH_TKPS_CC */
