/*
 * atobj-rcvr.h --
 *
 *      class AtobjRcvr (see below)
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  $Header: /usr/mash/src/repository/mash/mash-1/atobj/atobj-rcvr.h,v 1.7 2002/02/03 03:10:21 lim Exp $
 */

#ifndef ATOBJ_RCVR_H
#define ATOBJ_RCVR_H

#include "atobj-pkt.h"
#include "srm/source-srm.h"

class AtobjSM;
class Atobj_request;
class Atobj_reply;

/*
 *-------------------------------------------------------------------------
 *
 * class AtobjRcvr --
 *
 *        An active object receiver is the class that handles the
 *        active objects streams from a end host (i.e. SRM_Source).
 *        It handles the demultiplexing of streams into each active object.
 *
 *-------------------------------------------------------------------------
 */

class AtobjRcvr : public SRM_PacketHandler {
public:
        AtobjRcvr(AtobjSM *pSM, const SrcId& srcId);
        virtual ~AtobjRcvr();
        virtual int command(int argc, const char*const* argv);

        virtual void recv(Byte *pb, u_int len);
        /* REVIEW: SRM should use unsigned... */
        virtual void recv(Byte *pb, int len) { recv(pb, (u_int)len); }

        /* create a new animation if it does not exist */
        /* returns: created? */
        int define_animation(const AnimationId& anmId);

        /* creates a new animation (will create the tcl classes... */
        char* create_animation(const AnimationId& anmId);

        /* returns the (tcl) name of an animation given anmId */
        const char* get_animation(const AnimationId& anmId);

        /*  Adds a new animation given its name, this is appropriate for local
         *     receivers */
        void add_animation(const char* szAnim, const AnimationId& anmId);

        virtual int next_ADU(Byte *pb, int len);

        void handleRequest(AtoPkt_request *pPkt);
        void handleReply(AtoPkt_reply* pPkt);

        Atobj_request* schedRequest(const AnimationId& anmId);

        // returns true if request is still needed, false otherwise
        int updateRequest(Atobj_request* pRequest,
                          const AnimationId& anmId);

        u_int fillRequest(Atobj_request* pRequest,
                          const AnimationId& anmId, Byte* pb, int len);

        /* returns false if invalid id's, true o.w. */
        int cancelRequest(Atobj_request* pRequest, const AnimationId& anmId,
                          int wantCallback);

        Atobj_reply* schedReply(const AnimationId& anmId);

        /* returns false if invalid id's, true o.w. */
        int cancelReply(Atobj_reply* pReply, const AnimationId& anmId);

        // returns total len of reply
        u_int fillReply(Atobj_reply* pRequest,
                        const AnimationId& anmId, Byte* pb, int len);

        u_int fillSA(Byte* pb);
        void handleSA(AtoPkt_SA* pSA);

        // accessor functions
        const SrcId& srcId() {return srcId_;}
private:
        u_int nextAnmId_;
        SrcId srcId_;
        AtobjSM *pMgr_;
        Tcl_HashTable *phtAnimations_;
        Tcl_HashTable *phtRequests_;
        Tcl_HashTable *phtReplies_;
};

#endif /* #ifdef ATOBJ_RCVR_H */
