/*
 * timeval.h --
 *
 *      Time Val header
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/archive/timeval.h,v 1.6 2002/02/03 03:09:26 lim Exp $
 */


#ifndef MASH_TIMEVAL_H
#define MASH_TIMEVAL_H

#ifndef WIN32
#include <sys/time.h>
#else
#include <time.h>
#endif

inline int operator <= (timeval tv1, timeval tv2)
{
	return (tv1.tv_sec < tv2.tv_sec ||
		(tv1.tv_sec==tv2.tv_sec && tv1.tv_usec<=tv2.tv_usec));
}


timeval operator - (timeval tv1, timeval tv2);
timeval operator + (timeval tv1, timeval tv2);


inline double
tvtof(const timeval &tv)
{
	return double(tv.tv_sec) + (tv.tv_usec * 1E-6);
}


inline timeval
ftotv(double d)
{
	timeval tv;
	tv.tv_sec = int(d);
	tv.tv_usec= int((d - tv.tv_sec) * 1E6);
	return tv;
}


char * tvtoa(const timeval &tv);


#endif /* MASH_TIMEVAL_H */
