;/* Copyright 2000, International Business Machines Corporation and others.
; * All Rights Reserved.
; *
; * This software has been released under the terms of the IBM Public
; * License.  For details, see the LICENSE file in the top-level source
; * directory or online at http://www.openafs.org/dl/license10.html
; * event.mc --(mc)--> event.[h|rc] --(logevent.h + event.h)--> afsevent.h
; */
;
;#ifndef OPENAFS_AFSEVENT_H
;#define OPENAFS_AFSEVENT_H
;
;
;/* AFS event.mc format.
; *
; * AFS event messages are grouped by category.  The MessageId of the
; * first message in a given category specifies the starting identifier
; * range for that category; the second and later messages in a category
; * do NOT specify a MessageId value and thus receive the value of the
; * previous message plus one.
; *
; * To add a new message to an existing category, append it to the end of
; * that category.  To create a new category, provide an appropriate
; * comment line and specify a non-conflicting MessageId for the first
; * message in the new category.
; */
;


MessageIdTypedef=unsigned
LanguageNames=(Chinese_Traditional=1:MSG000001)

;
;/* Test message text */
;

MessageId=0x0001
Severity=Informational
SymbolicName=AFSEVT_SVR_TEST_MSG_NOARGS
Language=Chinese_Traditional
AFS AƥxհTC
.

MessageId=
Severity=Warning
SymbolicName=AFSEVT_SVR_TEST_MSG_TWOARGS
Language=Chinese_Traditional
AFS AƥxհT (str1: %1, str2: %2)C
.



;
;/* General messages for all AFS server processes */
;

MessageId=0x0101
Severity=Error
SymbolicName=AFSEVT_SVR_FAILED_ASSERT
Language=Chinese_Traditional
AFS ABzĽT{Gbɮ %2  %1 C
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_NO_INSTALL_DIR
Language=Chinese_Traditional
%1 Lk AFS nw˥ؿC
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_WINSOCK_INIT_FAILED
Language=Chinese_Traditional
%1 Lk_l]w Windows Sockets {wC
.



;
;/* AFS BOS control (startup/shutdown) service messages */
;

MessageId=0x0201
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_STARTED
Language=Chinese_Traditional
wҰ AFS BOS AȡC
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_STOPPED
Language=Chinese_Traditional
w AFS BOS AȡC
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_SCM_COMM_FAILED
Language=Chinese_Traditional
AFS BOS AȵLkPt SCM qHC
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_HANDLER_REG_FAILED
Language=Chinese_Traditional
AFS BOS AȵLknƥBz`CAFS An骺[ciणTC
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_INSUFFICIENT_RESOURCES
Language=Chinese_Traditional
AFS BOS AȵLkontθ귽C
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_INTERNAL_ERROR
Language=Chinese_Traditional
AFS BOS Aȵoͤ~C
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_NO_INSTALL_DIR
Language=Chinese_Traditional
AFS BOS AȵLk AFS nw˥ؿCAFS An骺[ciणTC
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_START_FAILED
Language=Chinese_Traditional
AFS BOS AȵLkҰʩέsҰ AFS DAC
.

MessageId=
Severity=Error
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_STOP_FAILED
Language=Chinese_Traditional
AFS BOS AȵLk AFS DACҦ AFS ABzHʤ覡
]յ۳zL fskill Oǰe SIGQUIT T AFS DA^C
.

MessageId=
Severity=Warning
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_STOP_TIMEOUT
Language=Chinese_Traditional
AFS BOS Aȩ󵥭 AFS DACˬdҦ AFS ABzwbsҰʪAȤeC
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_RESTART
Language=Chinese_Traditional
AFS BOS AȥbsҰ AFS DAC
.

MessageId=
Severity=Informational
SymbolicName=AFSEVT_SVR_BCS_BOSSERVER_EXIT
Language=Chinese_Traditional
AFS BOS AȰ AFS DAAåBnDsҰʡC
.



;
;#endif /* OPENAFS_AFSEVENT_H */
