// -*- Mode: C++; -*-
//                            Package   : omniORB
// corbaDFloat.cc             Created on: 23/04/98
//                            Author    :
//
//    Copyright (C) 1996-1999 AT&T Laboratories Cambridge
//
//    This file is part of the omniORB library
//
//    The omniORB library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
//    02111-1307, USA
//
//
// Description:
//	Float and Double conversion operators for OpenVMS.
//	This file is specific to OpenVMS.
//

/* 
   $Log: corbaFloat.cc,v $

   Revision 1.5  2000/05/12 14:02:58  bcv
   Modified to either throw a CORBA::DATA_CONVERSION exception or call IdlError
   when an IEEE floating point value cannot be converted to native type.

   Revision 1.4  1999/07/27 15:37:01  bcv
   Extracted from corbaFloat.cc for redesign.

   Revision 1.3  1999/03/11 16:25:52  djr
   Updated copyright notice

   Revision 1.2  1998/08/14 13:44:04  sll
   Added pragma hdrstop to control pre-compile header if the compiler feature
   is available.

   Revision 1.1  1998/08/11 16:39:41  sll
   Initial revision

*/

#include <errno.h>
#ifdef USE_IDLERROR

#include <idlerr.h>
#include <omniORB4/CORBA_sysdep.h>
#include <omniORB4/CORBA_basetypes.h>

extern char* currentFile;
extern int   yylineno;

#else

#include <omniORB4/CORBA.h>
#include <exceptiondefs.h>

#endif

#ifdef HAS_pch
#pragma hdrstop
#endif

#if !defined(__VMS) 
#error "This module is intended only for VMS"
#endif

#if !__D_FLOAT
#error "This module must be compiled with /Float=D"
#endif

#include <cvtdef.h>
extern "C" unsigned int CVT$CONVERT_FLOAT(...);

#if !defined(__DECCXX) || __DECCXX_VER >= 60000000
namespace {
#else
static
#endif
  void dataConversionError(int status) {
    vaxc$errno=status;
    errno=EVMSERR;

#ifdef USE_IDLERROR
    IdlError(currentFile, yylineno, "Floating point conversion error.");
#else
    OMNIORB_THROW(DATA_CONVERSION, errno, CORBA::COMPLETED_NO);
#endif

  } // dataConversionError

#if !defined(__DECCXX) || __DECCXX_VER >= 60000000
}   // namespace
#endif

void _CORBA_Float::cvt_d_(float f) {
  int status(
    CVT$CONVERT_FLOAT(
      &f,
      CVT$K_VAX_F,
      &pd_f,
      CVT$K_IEEE_S,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1)
    dataConversionError(status);
}

float _CORBA_Float::cvt_d_() const {
  float f;
  int status(
    CVT$CONVERT_FLOAT(
      &pd_f,
      CVT$K_IEEE_S,
      &f,
      CVT$K_VAX_F,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1) {
    dataConversionError(status);
    f=0;
  }
  return f;
}

void _CORBA_Double::cvt_d_(double d) {
  int status(
    CVT$CONVERT_FLOAT(
      &d,
      CVT$K_VAX_D,
      &pd_d,
      CVT$K_IEEE_T,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1)
    dataConversionError(status);
}

double _CORBA_Double::cvt_d_() const {
  double d;
  int status(
    CVT$CONVERT_FLOAT(
      &pd_d,
      CVT$K_IEEE_T,
      &d,
      CVT$K_VAX_D,
      CVT$M_ROUND_TO_NEAREST
    )
  );
  if((status & 1) != 1) {
    dataConversionError(status);
    d=0;
  }
  return d;
}

