#!/usr/bin/perl
#
# $Id: EthernetPacket.pm,v 1.3 2001/07/02 22:10:00 levine Exp $
#
# Copyright (C) 2001  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################

use NWatch::Packet;

use strict;

####################################################################
#
# ethernet packet
#
# Raw device packet, expects MAC addresses first but not preample
# data.
#
####################################################################


package NWatch::ethernet_packet;

@NWatch::ethernet_packet::ISA = qw( NWatch::packet );

sub protocol_name { "ethernet"; }


sub new
{
    my( $type, $data ) = @_;

    # init from base class
    my $self = NWatch::packet::new( $type, $data );

    # unpack fields
    my $to = substr( $data, 0, 6 );
    my $from = substr( $data, 6, 6 );
    my $protocol = unpack "x12n", $data;
    my $payload = substr( $data, 14, length( $data ) - 14 );

    # make fields persistent
    $self->set( "from", $from );
    $self->set( "to", $to );
    $self->set( "protocol", $protocol );
    $self->set( "payload", $payload );

    # for any known protocols, stack a packet instance on top
    # check proto ID
    # if known, set next to a new instance of proto with payload
    # for now, protocols are hard-coded

#    print "epk: proto $protocol \n";

    if( $protocol == 2048 )	# IPv4
    {
	$self->next( new NWatch::ipv4_packet( $payload ) );
    }


    $self;
}


sub format_addr
{
    my( $self, $a ) = @_;
    return sprintf "%02x:%02x:%02x:%02x:%02x:%02x", unpack( "CCCCCC", $a ); 
}


1;




















