#ifndef __NPASTRUCTS_H__
#define __NPASTRUCTS_H__

struct ConnectionInfo{
  long connState;
  unsigned char *remhost;
};

class ConnectionInfoRequest{
public:
  unsigned short port;
  char *statebuf;
  char *remaddrbuf;
  ConnectionInfoRequest *next;

  ConnectionInfo *conninfo;

  inline ConnectionInfoRequest(unsigned short prt,ConnectionInfoRequest *nxt):
    port(prt),next(nxt){}
};

class GeneralPrinterInfo {
public:
  char *sysDesc;
  char *sysContact;
  char *sysLocation;
  char *hwaddr;
  unsigned char *gateway;
  unsigned char *netmask;
  long iftype;
  /* this isn't necessary it just makes debugging easier */
  inline GeneralPrinterInfo():sysDesc(NULL),sysContact(NULL),sysLocation(NULL),
    hwaddr(NULL),gateway(NULL),netmask(NULL){}
};

struct HostPrinterInfo {
  long memsize;
  long prstatus;
};

struct HPPrivInfo {
  char *status;
  char *frontpanel;
  long pagecount;
};

struct MediaPathInfo{
  long maxSpeedPrintUnit;
  long mediaSizeUnit;
  long maxSpeed;
  long maxMediaFeedDir;
  long maxMediaXFeedDir;
  long minMediaFeedDir;
  long minMediaXFeedDir;
  long type;
  long status;
  char *description;
};

struct InputTrayInfo {
  long type;
  long dimUnit;
  long dimFeedDir;
  long dimXFeedDir;
  long capUnit;
  long maxCap;
  long curLev;
  long status;
  char *mediaName;
  char *name;
  char *desc;
}; // base input tray initial data

struct LangInfo{
  long family;
  char *langLevel;
  char *langVersion;
  char *description;
  char *version;
  long orientation;
  long feedAddressability;
  long xFeedAddressability;
  long twoWay;
};

struct HrStorageTable{
  char *desc;
  long allocunits;
  long size;
  long used;
  long failures;
};

struct CoverTable{
  char *desc;
  long status;
};

struct ProtocolTable{
  long type;
  char *version;
  long curjclidx;
  long defpdlidx;
  long state;
  long status;
};

struct MarkerTable{
  long marktech;
  long counterunits;
  long lifecount;
  long processcolorants;
  long addrunits;
  long addrfeeddir;
  long addrxfeeddir;
  long northmargin;
  long southmargin;
  long eastmargin;
  long westmargin;
  long status;
};

struct MarkerSuppliesTable{
  long colorantidx;
  long msclass;
  long type;
  char *desc;
  long supplyunit;
  long maxcap;
  long level;
};

struct AlertTable{
  long severityLevel;
  long trainingLevel;
  long group;
  long groupIndex;
  long location;
  long code;
  char *desc;
  unsigned long time;
  
  const char *decode_code();
};

#endif
