#include "netwibtest.h"

/*-------------------------------------------------------------*/
static netwib_err netwib_buf_search_re_test2(netwib_conststring str,
                                             netwib_conststring strre,
                                             netwib_bool casesensitive,
                                             netwib_conststring want)
{
  netwib_buf buf, re, found;

  netwib_er(netwib_buf_init_ext_text(str, &buf));
  buf.totalsize--;
  netwib_er(netwib_buf_init_ext_text(strre, &re));
  re.totalsize--;
  netwib_er(netwib_buf_search_re(&buf, &re, casesensitive, &found));
  netwib_er(netwibtest_buf_content2(&found, want));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
static netwib_err netwib_buf_search_re_test(void)
{
  netwib_buf buf, re;

  puts("++++----\nTest of netwib_buf_search_re");

  netwib_er(netwib_buf_init_ext_text("abcdef", &buf));
  netwib_er(netwib_buf_init_ext_text("ab[cdef", &re));
  netwib_eir(netwib_buf_search_re(&buf, &re, NETWIB_TRUE, NULL),
             NETWIB_ERR_FUREGCOMP);
  netwib_er(netwib_err_display(NETWIB_ERR_FUREGCOMP, NETWIB_ERR_ENCODETYPE_FULL));

  netwib_er(netwib_buf_init_ext_text("abcdef", &buf));
  netwib_er(netwib_buf_init_ext_text("abdef", &re));
  netwib_eir(netwib_buf_search_re(&buf, &re, NETWIB_TRUE, NULL),
             NETWIB_ERR_NOTFOUND);

  netwib_er(netwib_buf_search_re_test2("abcde", "abcde", NETWIB_TRUE, "abcde"));
  netwib_er(netwib_buf_search_re_test2("abc", "^abc",NETWIB_TRUE, "abc"));
  netwib_er(netwib_buf_search_re_test2("abc", "abc$",NETWIB_TRUE, "abc"));
  netwib_er(netwib_buf_search_re_test2("abc", "a.c",NETWIB_TRUE, "abc"));
  netwib_er(netwib_buf_search_re_test2("abc", "bc",NETWIB_TRUE, "bc"));
  netwib_er(netwib_buf_search_re_test2("abc", ".c",NETWIB_TRUE, "bc"));
  netwib_er(netwib_buf_search_re_test2("abc", "[zb]c",NETWIB_TRUE, "bc"));
  netwib_er(netwib_buf_search_re_test2("abc", "Bc",NETWIB_FALSE, "bc"));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
static netwib_err netwib_buf_search_regexp_test2(netwib_conststring str,
                                                 netwib_conststring strre,
                                                 netwib_uint32 numset,
                                                 netwib_conststring want0,
                                                 netwib_conststring want1,
                                                 netwib_conststring want2)
{
  netwib_buf buf, bufre;
  netwib_regexp re;

  netwib_er(netwib_buf_init_ext_text(str, &buf));
  netwib_er(netwib_buf_init_ext_text(strre, &bufre));
  netwib_er(netwib_buf_search_regexp(&buf, &bufre, NETWIB_TRUE, &re));

  if (re.numset != numset) {
    netwib_er(netwib_fmt_display("numset=%{uint32}!=wanted=%{uint32})\n",
                                 re.numset, numset));
    return(NETWIBTEST_ERR_6);
  }

  netwib_er(netwibtest_buf_content2(&re.array[0], want0));
  if (numset > 1) {
    netwib_er(netwibtest_buf_content2(&re.array[1], want1));
  }
  if (numset > 2) {
    netwib_er(netwibtest_buf_content2(&re.array[2], want2));
  }

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
static netwib_err netwib_buf_search_regexp_test(void)
{
  puts("++++----\nTest of netwib_buf_search_regexp");

  netwib_er(netwib_buf_search_regexp_test2("abcdef", "abcdef",
                                           1, "abcdef", "", ""));
  netwib_er(netwib_buf_search_regexp_test2("abcdef", "ab(cd)ef",
                                           2, "abcdef", "cd", ""));
  netwib_er(netwib_buf_search_regexp_test2("abcdef", "ab(cd)(e)f",
                                           3, "abcdef", "cd", "e"));
  netwib_er(netwib_buf_search_regexp_test2("abcdef", "ab((cd)e)f",
                                           3, "abcdef", "cde", "cd"));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
/*-------------------------------------------------------------*/
netwib_err netwibtest_dat_regexp(void)
{
  puts("###########################################\nTest of dat/regexp");
  netwib_er(netwib_buf_search_re_test());
  netwib_er(netwib_buf_search_regexp_test());

  return(NETWIB_ERR_OK);
}

