/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef LINUX
#define __FAVOR_BSD
#define __USE_BSD
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <errno.h>

#include <callbacks.h>
#include <interface.h>
#include <support.h>

#include <netdude/nd.h>
#include <netdude/nd_debug.h>
#include <netdude/nd_capture.h>
#include <netdude/nd_dialog.h>
#include <netdude/nd_clipboard.h>
#include <netdude/nd_globals.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_main.h>
#include <netdude/nd_misc.h>
#include <netdude/nd_trace.h>
#include <netdude/nd_trace_registry.h>
#include <netdude/nd_plugin.h>
#include <netdude/nd_prefs.h>
#include <netdude/nd_recent.h>
#include <netdude/nd_protocol_plugin.h>
#include <netdude/nd_protocol_inst.h>

void
on_filesel_ok_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_filesel_ok(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_filesel_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_filesel_close();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


gboolean
on_toplevel_delete_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  nd_main_safe_exit();
  
  return TRUE;
  TOUCH(user_data);
  TOUCH(widget);
  TOUCH(event);
}



void
on_confirm_yes_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);
  nd_trace_save(nd_trace_registry_get_current());
  nd_main_unsafe_exit();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_confirm_no_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);
  nd_main_unsafe_exit();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_confirm_cancel_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;
  
  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  TOUCH(user_data);
}


void
on_trace_list_row_move               (GtkCList        *clist,
				      gint             arg1,
				      gint             arg2,
				      gpointer         user_data)
{
  nd_trace_move_packet(nd_trace_registry_get_current(), arg1, arg2);

  return;
  TOUCH(clist);
  TOUCH(user_data);
}


void
on_packet_hide_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_sel_hide(nd_trace_registry_get_current());

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_packet_show_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_sel_show(nd_trace_registry_get_current());

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_packet_cut_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_clipboard_cut();

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_packet_copy_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_clipboard_copy();

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_packet_paste_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_clipboard_paste();

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}



gboolean
on_trace_list_button_press_event     (GtkWidget       *widget,
				      GdkEventButton  *event,
				      gpointer         user_data)
{
  ND_Trace     *trace;
  int           row, col;

  D_ENTER;

  return_val_if_no_current_trace(trace, FALSE);
  nd_gui_timestamp_hide();

  if ((event->button == 1)                      &&
      ((event->state & GDK_MODIFIER_MASK) == 0))
    {
      nd_trace_clear_selection(trace);
      gtk_clist_unselect_all(GTK_CLIST(widget));
    }
  else if (event->button == 3)
    {
      gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y, &row, &col);

      if (nd_trace_sel_size(trace) == 0)
	gtk_clist_select_row(GTK_CLIST(widget), row, 0);

      /* nd_packet_set(nd_trace_packet_get_nth(row)); */

      nd_gui_show_packet_menu(event);
    }

  D_RETURN_(FALSE);
  TOUCH(user_data);
}


void
on_trace_list_unselect_row           (GtkCList        *clist,
				      gint             row,
				      gint             column,
				      GdkEvent        *event,
				      gpointer         user_data)
{
  D_ENTER;
  nd_trace_unselect_packet(nd_trace_registry_get_current(), row);

  D_RETURN;
  TOUCH(user_data);
  TOUCH(clist);
  TOUCH(event);
  TOUCH(column);
}


void
on_trace_list_select_row             (GtkCList        *clist,
				      gint             row,
				      gint             column,
				      GdkEvent        *event,
				      gpointer         user_data)
{
  ND_Trace *trace;

  D_ENTER;
  return_if_no_current_trace(trace);

  nd_trace_select_packet(trace, row);
  
  D_RETURN;
  TOUCH(user_data);
  TOUCH(clist);
  TOUCH(event);
  TOUCH(column);
}

void
on_packet_unselect_all_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Trace   *trace;

  D_ENTER;
  return_if_no_current_trace(trace);
  gtk_clist_unselect_all(GTK_CLIST(trace->list));

  /* This called OUR callback -- no signals are sent,
   * so we need to do this manually
   */
  nd_trace_clear_selection(trace);
  nd_trace_set_current_packet(trace, NULL);

  D_RETURN;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_packet_select_all_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Trace   *trace;

  D_ENTER;
  return_if_no_current_trace(trace);
  gtk_clist_select_all(GTK_CLIST(trace->list));

  /* This called OUR callback -- no signals are sent,
   * so we need to do this manually
   */
    
  nd_trace_full_selection(trace);
  nd_trace_set_current_packet(trace,
			      nd_trace_packet_get_nth(trace, 0));

  D_RETURN;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_trace_list_end_selection          (GtkCList        *clist,
				      gpointer         user_data)
{
  return;
  TOUCH(clist);
  TOUCH(user_data);
}

void
on_packet_delete_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  D_ENTER;
  nd_trace_sel_delete(nd_trace_registry_get_current());

  D_RETURN;
  TOUCH(user_data);
  TOUCH(menuitem);
}


gboolean
on_menubar_button_press_event          (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  nd_gui_sync();
  
  return FALSE;
  TOUCH(widget);
  TOUCH(event);
  TOUCH(user_data);
}


void
on_trace_list_select_all             (GtkCList        *clist,
				      gpointer         user_data)
{
  ND_Trace *trace;

  D_ENTER;
  return_if_no_current_trace(trace);

  nd_trace_full_selection(trace);
  nd_trace_set_current_packet(trace, nd_trace_packet_get_nth(trace, 0));

  D_RETURN;
  TOUCH(clist);
  TOUCH(user_data);
}


void
on_trace_list_unselect_all           (GtkCList        *clist,
				      gpointer         user_data)
{
  D_ENTER;
  nd_trace_clear_selection(nd_trace_registry_get_current());

  D_RETURN;
  TOUCH(clist);
  TOUCH(user_data);
}


void
on_trace_list_size_allocate          (GtkWidget       *widget,
				      GtkAllocation   *allocation,
				      gpointer         user_data)
{
  gtk_clist_set_column_width(GTK_CLIST(widget), 0,
			     allocation->width - 60);

  return;
  TOUCH(user_data);
}


void
on_about_okay_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *dialog;

  dialog = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_hide(dialog);

  return;
  TOUCH(user_data);
}


void
on_preferences_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_prefs_dialog_show();

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_pref_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_dialog_ok();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_pref_cancel_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_dialog_cancel();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_pref_apply_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_dialog_apply();

  return;
  TOUCH(button);
  TOUCH(user_data);
}


gboolean
on_trace_win_bar_button_release_event  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  return FALSE;
  TOUCH(widget);
  TOUCH(event);
  TOUCH(user_data);
}


void
on_plugin_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Plugin *plugin;

  plugin = (ND_Plugin*) gtk_object_get_data(GTK_OBJECT(menuitem), "plugin");
  D_ASSERT_PTR(plugin);

  nd_plugin_run(plugin);

  return;
  TOUCH(user_data);
}


void
on_pref_tcpdump_loc_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_select_tcpdump();
  
  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_tcpdump_error_okay_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *w;

  w = gtk_widget_get_toplevel(GTK_WIDGET(button));
  gtk_widget_destroy(w);

  return;
  TOUCH(user_data);
}


gboolean
on_trace_list_motion_notify_event    (GtkWidget       *widget,
				      GdkEventMotion  *event,
				      gpointer         user_data)
{
  nd_gui_timestamp_schedule(GTK_CLIST(widget), event);

  return FALSE;
  TOUCH(user_data);
}


gboolean
on_trace_list_leave_notify_event     (GtkWidget       *widget,
				      GdkEventCrossing *event,
				      gpointer         user_data)
{
  nd_gui_timestamp_hide();

  return FALSE;
  TOUCH(widget);
  TOUCH(event);
  TOUCH(user_data);
}


gboolean
on_trace_list_key_press_event        (GtkWidget       *widget,
				      GdkEventKey     *event,
				      gpointer         user_data)
{
  nd_gui_timestamp_hide();

  return FALSE;
  TOUCH(widget);
  TOUCH(event);
  TOUCH(user_data);
}


gboolean
on_splash_window_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(widget);

  return FALSE;
  TOUCH(event);
  TOUCH(user_data);
}


void
on_recent_item0_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(0);

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_recent_item1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(1);

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_recent_item2_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(2);

  return;
  TOUCH(menuitem);
  TOUCH(user_data)
}


void
on_recent_item3_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(3);

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_recent_item4_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_recent_load(4);

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_about_plugin_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Plugin *plugin;

  plugin = (ND_Plugin*) gtk_object_get_data(GTK_OBJECT(menuitem), "plugin");
  nd_plugin_show_about(plugin);

  return;
  TOUCH(user_data);
}


void
on_about_proto_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_ProtoPlugin *pp;

  pp = (ND_ProtoPlugin*) gtk_object_get_data(GTK_OBJECT(menuitem), "plugin");
  nd_proto_plugin_show_about(pp);

  return;
  TOUCH(user_data);
}


void
on_trace_close_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_Trace *trace = (ND_Trace *) user_data;

  nd_trace_close(trace);

  return;
  TOUCH(button);
}


void
on_traces_notebook_switch_page         (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  ND_Trace *trace;

  D_ENTER;
  trace = gtk_object_get_data(GTK_OBJECT(page->child), "trace");
  D_ASSERT_PTR(trace);

  nd_trace_registry_set_current(trace);

  D_RETURN;
  TOUCH(notebook);
  TOUCH(page_num);
  TOUCH(user_data);
}


void
on_protos_notebook_switch_page         (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
  ND_Trace        *trace;
  ND_ProtoInfo    *pinf;
  ND_ProtoData    *pd;

  trace = gtk_object_get_data(GTK_OBJECT(notebook), "trace");
  D_ASSERT_PTR(trace);

  if (!trace->cur_packet)
    return;

  pinf = gtk_object_get_data(GTK_OBJECT(page->child), "pinf");
  D_ASSERT_PTR(pinf);

  if (!pinf)
    return;

  pd = nd_packet_get_proto_data(trace->cur_packet, pinf->inst.proto, pinf->inst.nesting);
  nd_trace_set_current_proto_selection(trace, &pd->inst);
  nd_trace_set_current_proto(trace, &pd->inst, TRUE);
  
  return;
  TOUCH(page_num);
  TOUCH(user_data);
}


void
on_file_save_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_save(nd_trace_registry_get_current());  

  return;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_file_save_as_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ND_Trace *trace;

  return_if_no_current_trace(trace);
  nd_trace_save_as_dialog(trace, NULL, NULL);

  return;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_file_new_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_registry_add(nd_trace_new(NULL));

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_file_open_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_trace_load_dialog();
		    
  return;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_file_exit_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_main_safe_exit();

  return;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_dialog_about();

  return;
  TOUCH(user_data);
  TOUCH(menuitem);
}


void
on_ip_entry_ok_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_ip_ok();

  return;
  TOUCH(button); TOUCH(user_data);
}


void
on_ip_entry_cancel_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_ip_cancel();

  return;
  TOUCH(button); TOUCH(user_data);
}



void
on_change_mono_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_prefs_fontsel_show();

  return;
  TOUCH(button); TOUCH(user_data);
}


void
on_font_ok_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *toplevel;

  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(button));
  nd_dialog_fontsel_ok(GTK_FONT_SELECTION_DIALOG(toplevel));

  return;
  TOUCH(user_data);
}


void
on_font_cancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *toplevel;

  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(button));
  nd_dialog_fontsel_cancel(GTK_FONT_SELECTION_DIALOG(toplevel));

  return;
  TOUCH(user_data);
}


void
on_font_apply_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *toplevel;

  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(button));
  nd_dialog_fontsel_apply(GTK_FONT_SELECTION_DIALOG(toplevel));

  return;
  TOUCH(user_data);
}


gboolean
on_number_spin_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  GtkWidget *w2;

  D_ENTER;

  w = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "number_ok_button");
  D_ASSERT_PTR(w2);

  if (event->keyval == GDK_Return)
    on_number_ok_clicked(GTK_BUTTON(w2), user_data);
  
  D_RETURN_(FALSE);
}


void
on_number_decimal_toggled              (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *w, *entry;
  guint      value;
  char      *errptr;

  D_ENTER;

  if (gtk_toggle_button_get_active(togglebutton))
    {
      w = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
      entry = gtk_object_get_data(GTK_OBJECT(w), "generic_entry");
      D_ASSERT_PTR(entry);
      
      value = strtoul(gtk_entry_get_text(GTK_ENTRY(entry)), &errptr, 16);
      
      if ((*errptr != '\0') || (errno == ERANGE))
	{
	  D(("Warning -- conversion error when converting %s\n",
	     gtk_entry_get_text(GTK_ENTRY(entry))));
	}
      else
	gtk_object_set_data(GTK_OBJECT(w), "value", GINT_TO_POINTER(value));
      
      nd_dialog_number_update();
      nd_dialog_number_set_base(ND_BASE_DEC);
    }
  
  D_RETURN;
  TOUCH(user_data);
}


void
on_number_hex_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *w, *entry;
  guint      value;
  char      *errptr;
  
  D_ENTER;
  
  if (gtk_toggle_button_get_active(togglebutton))
    {
      w = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
      entry = gtk_object_get_data(GTK_OBJECT(w), "generic_spin");
      D_ASSERT_PTR(entry);
      
      value = strtoul(gtk_entry_get_text(GTK_ENTRY(entry)), &errptr, 10);
      
      if ((*errptr != '\0') || (errno == ERANGE))
	{
	  D(("Warning -- conversion error when converting %s\n", 
	     gtk_entry_get_text(GTK_ENTRY(entry))));
	}
      else
	gtk_object_set_data(GTK_OBJECT(w), "value", GINT_TO_POINTER(value));
      
      nd_dialog_number_update();
      nd_dialog_number_set_base(ND_BASE_HEX);
    }

  D_RETURN;
  TOUCH(user_data);
}


void
on_number_ok_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_number_ok(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_number_cancel_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_number_cancel(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


gboolean
on_largenumber_entry_key_press_event    (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GtkWidget *w;
  GtkWidget *w2;

  w = gtk_widget_get_toplevel(GTK_WIDGET(widget));
  w2 = gtk_object_get_data(GTK_OBJECT(w), "largenumber_ok");
  D_ASSERT_PTR(w2);

  if (event->keyval == GDK_Return)
    on_largenumber_ok_clicked(GTK_BUTTON(w2), user_data);
  
  return TRUE;
}


void
on_largenumber_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_largenumber_ok(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_largenumber_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Same handling as for normal dialog :) */
  nd_dialog_number_cancel(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_largenumber_up_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_largenumber_up(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_largenumber_down_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_dialog_largenumber_down(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_capt_start_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_capture_dialog_start(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_capt_close_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_Capture *capt;
  GtkWidget *toplevel;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(button));
  capt = gtk_object_get_data(GTK_OBJECT(toplevel), "capture");
  nd_capture_stop(capt);
  nd_capture_dialog_close(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(user_data);
}


void
on_capt_size_lim_checkbutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *toplevel, *w;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
  w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_size_spinbutton");
  D_ASSERT_PTR(w);
  gtk_widget_set_sensitive(w, gtk_toggle_button_get_active(togglebutton));

  return;
  TOUCH(user_data);
}


void
on_capt_stop_count_checkbutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *toplevel, *w;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
  w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_stop_count_spinbutton");
  D_ASSERT_PTR(w);
  gtk_widget_set_sensitive(w, gtk_toggle_button_get_active(togglebutton));

  return;
  TOUCH(user_data);
}


void
on_capt_stop_time_checkbutton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *toplevel, *w;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
  w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_stop_time_spinbutton");
  D_ASSERT_PTR(w);
  gtk_widget_set_sensitive(w, gtk_toggle_button_get_active(togglebutton));

  return;
  TOUCH(user_data);
}


void
on_capt_stop_size_checkbutton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *toplevel, *w;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
  w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_stop_size_spinbutton");
  D_ASSERT_PTR(w);
  gtk_widget_set_sensitive(w, gtk_toggle_button_get_active(togglebutton));

  return;
  TOUCH(user_data);
}


void
on_capt_lim_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *toplevel, *w;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
  w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_limit_spinbutton");
  D_ASSERT_PTR(w);
  gtk_widget_set_sensitive(w, gtk_toggle_button_get_active(togglebutton));

  return;
  TOUCH(user_data);
}


void
on_capt_filter_file_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *toplevel, *w;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));

  if (gtk_toggle_button_get_active(togglebutton))
    {
      w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_filter_entry");
      D_ASSERT_PTR(w);
      gtk_widget_set_sensitive(w, FALSE);

      w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_filter_file_combo");
      D_ASSERT_PTR(w);
      gtk_widget_set_sensitive(w, TRUE);

      w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_filter_file_button");
      D_ASSERT_PTR(w);
      gtk_widget_set_sensitive(w, TRUE);
    }
  else
    {
      w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_filter_entry");
      D_ASSERT_PTR(w);
      gtk_widget_set_sensitive(w, TRUE);

      w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_filter_file_combo");
      D_ASSERT_PTR(w);
      gtk_widget_set_sensitive(w, FALSE);

      w = gtk_object_get_data(GTK_OBJECT(toplevel), "capt_filter_file_button");
      D_ASSERT_PTR(w);
      gtk_widget_set_sensitive(w, FALSE);
    }

  return;
  TOUCH(user_data);
}


void
on_capt_filter_file_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
  nd_capture_choose_filter_file(gtk_widget_get_toplevel(GTK_WIDGET(button)));

  return;
  TOUCH(button);
  TOUCH(user_data);
}


void
on_capture_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  nd_capture_dialog_show();

  return;
  TOUCH(menuitem);
  TOUCH(user_data);
}


void
on_capt_stop_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  ND_Capture *capt;
  GtkWidget *toplevel;
  
  toplevel = gtk_widget_get_toplevel(GTK_WIDGET(button));
  capt = gtk_object_get_data(GTK_OBJECT(toplevel), "capture");
  D_ASSERT_PTR(capt);

  nd_capture_stop(capt);

  return;
  TOUCH(user_data);
}

void
on_apply_to_all_togglebutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ND_Trace *trace;

  return_if_no_current_trace(trace);

  if (gtk_toggle_button_get_active(togglebutton))
    trace->apply_to_all = TRUE;
  else
    trace->apply_to_all = FALSE;
  
  return;
  TOUCH(user_data);
}

