/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#include <netinet/if_fddi.h>

#include <netdude/nd_debug.h>
#include <netdude/nd_macros.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_packet.h>
#include <netdude/nd_dialog.h>
#include <netdude/nd_packet_iterator.h>

#include <nd_fddi.h>
#include <nd_fddi_callbacks.h>


void    
nd_fddi_fc_cb(ND_Packet   *packet,
	      guchar      *header,
	      guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct fddi_header *fh;

  fh = (struct fddi_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_fddi_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter Frame Control Code:"),
		   ND_BASE_HEX, fh->fddi_fc, 255,
		   nd_proto_iterate_8bit_cb, NULL,
		   packet, &cb_data);  
}


static void
fddi_dhost_okay_cb (guchar    *address,
		    int        address_len,
		    ND_Packet *packet,
		    void      *user_data)
{
  ND_PacketIterator     pit;
  struct fddi_header   *fh;
  int                   nesting;

  nesting = nd_packet_get_proto_nesting(packet, nd_fddi_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      fh = (struct fddi_header *) nd_packet_get_data(nd_pit_get(&pit), nd_fddi_get(), nesting);
      if (!fh)
	continue;

      memcpy(fh->fddi_dhost, address, FDDI_K_ALEN);
      nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
    }
  
  return;
  TOUCH(address_len);
  TOUCH(user_data);
}


void    
nd_fddi_dhost_cb(ND_Packet   *packet,
		 guchar      *header,
		 guchar      *data)
{
  struct fddi_header  *fh;

  fh = (struct fddi_header *) header;
  nd_dialog_hardware_address(_("Enter MAC dest. addr:"),
			     fh->fddi_dhost, 6,
			     fddi_dhost_okay_cb,
			     NULL,
			     packet, data);
}


static void
fddi_shost_okay_cb (guchar     *address,
		    int         address_len,
		    ND_Packet  *packet,
		    void       *user_data)
{
  ND_PacketIterator     pit;
  struct fddi_header   *fh;
  int                   nesting;

  nesting = nd_packet_get_proto_nesting(packet, nd_fddi_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      fh = (struct fddi_header *) nd_packet_get_data(nd_pit_get(&pit), nd_fddi_get(), nesting);
      if (!fh)
	continue;

      memcpy(fh->fddi_shost, address, FDDI_K_ALEN);
      nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
    }
  
  return;
  TOUCH(address_len);
  TOUCH(user_data);
}


void    
nd_fddi_shost_cb(ND_Packet   *packet,
		 guchar      *header,
		 guchar      *data)
{
  struct fddi_header  *fh;

  fh = (struct fddi_header *) header;
  nd_dialog_hardware_address(_("Enter MAC src. addr:"),
			     fh->fddi_shost, 6,
			     fddi_shost_okay_cb,
			     NULL,
			     packet, data);
}
