/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 sha1thread.h  -  background hashing of the shared files
                             -------------------
    begin                : Tue Nov 5 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef SHA1THREAD_H
#define SHA1THREAD_H

class MEventQueueSha1;

class MSha1Thread : public MThread  {
public: 
	MSha1Thread();
	~MSha1Thread();
	virtual void run();
protected:
	MEventQueueSha1* m_pEventQueue;
};

// hasing request -- a custom event
class MHashRequest : public MEvent{
public:
	MHashRequest(const CString& sRelPath, const CString& sPath, int nShareIndex) :
		MEvent(ET_MESSAGE, ES_NONE, MSG_SHA1_REQUEST),
		m_sRelPath(sRelPath),
		m_sPath(sPath),
		m_nShareIndex(nShareIndex)
	{}
	virtual CString Format(){
		return "Hash request for '" + m_sPath + "'";
	}
	virtual int GetMemUsage() {return sizeof(MHashRequest);}
	//
	CString m_sRelPath;
	CString m_sPath;
	int m_nShareIndex;
};

// hasing ready event
class MHashProgress : public MEvent{
public:
	MHashProgress(int nPercent, const CString& sPath, int nShareIndex) :
		MEvent(ET_MESSAGE, ES_NONE, MSG_SHA1_PROGRESS_UPDATE),
		m_nPercentDone(nPercent),
		m_sPath(sPath),
		m_nShareIndex(nShareIndex)
	{}
	virtual CString Format(){
		return "Hashing progress update for '" + m_sPath + "'";
	}
	virtual int GetMemUsage() {return sizeof(MHashProgress);}
	//
	CString m_sPath;
	int m_nShareIndex;
	int m_nPercentDone;
};

// hasing ready event
class MHashReady : public MEvent{
public:
	MHashReady(const char* szSha1, const CString& sPath, int nShareIndex) :
		MEvent(ET_MESSAGE, ES_NONE, MSG_SHA1_READY),
		m_sSha1(szSha1),
		m_sPath(sPath),
		m_nShareIndex(nShareIndex)
	{}
	virtual CString Format(){
		return "Hash ready for '" + m_sPath + "'";
	}
	virtual int GetMemUsage() {return sizeof(MHashReady);}
	//
	CString m_sPath;
	CString m_sSha1;
	int m_nShareIndex;
};

#endif
