/*
 * MusE FLUID Synth softsynth plugin
 *
 * Copyright (C) 2002 Robert Ham (node@users.sourcforge.net)
 *
 * $Id: fluidsynthgui.h,v 1.2 2003/11/07 19:51:20 lunar_shuttle Exp $
 *
 */

#ifndef __MUSE_FLUIDSYNTHGUI_H__
#define __MUSE_FLUIDSYNTHGUI_H__
#include <string>
#include <list>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qpushbutton.h>
#include <qmenubar.h>
#include <qsocketnotifier.h>
#include <alsa/asoundlib.h>
#include <qlistview.h>
#include <qheader.h>
#include "driver/midirawin.h"
#include "debug.h"
#include "xpm/buttondown.xpm"
#include "fluidsynthguibase.h"

#define MUSE_FLUID_ID_COL				0
#define MUSE_FLUID_SFNAME_COL			1
#define MUSE_FLUID_CHANNEL_COL			0
#define MUSE_FLUID_SF_ID_COL			1
#define MUSE_FLUID_MAX_NR_OF_CHANNELS 	16
#define MUSE_FLUID_SFDATALEN			1
#define MUSE_FLUID_UNSPECIFIED_CHANNEL	127
#define MUSE_FLUID_UNSPECIFIED_ID		127
#define MUSE_FLUID_UNSPECIFIED_PRESET	129
#define MUSE_FLUID_UNSPECIFIED_FONT		126
#define MUSE_FLUID_UNSPECIFIED_LASTDIR	127
//Various messages the gui and the client uses to communicate
enum {
	MUSE_FLUID_REVERB = 100,
	MUSE_FLUID_REVERB_ROOMSIZE,
	MUSE_FLUID_REVERB_DAMPING,
	MUSE_FLUID_REVERB_WIDTH,
	MUSE_FLUID_REVERB_LEVEL,
	MUSE_FLUID_CHORUS,
	MUSE_FLUID_CHORUS_NUMBER,
	MUSE_FLUID_CHORUS_TYPE,
	MUSE_FLUID_CHORUS_SPEED,
	MUSE_FLUID_CHORUS_DEPTH,
	MUSE_FLUID_CHORUS_LEVEL,
	MUSE_FLUID_GAIN,
	MUSE_FLUID_SOUNDFONT,
	MUSE_FLUID_STRING,
	MUSE_FLUID_STRING_END
};

enum {
	MUSE_FLUID_CLIENT_SEND_PARAMETER = 33,
	MUSE_FLUID_CLIENT_SEND_SOUNDFONTS,
	MUSE_FLUID_PARAMETER_GET,
	MUSE_FLUID_PARAMETER_REVERB,
	MUSE_FLUID_PARAMETER_CHORUS,
	MUSE_FLUID_GAIN_SET,
	MUSE_FLUID_GAIN_GET,
	MUSE_FLUID_SOUNDFONT_PUSH,
	MUSE_FLUID_SOUNDFONT_POP,

	MUSE_FLUID_CLIENT_SEND_ERROR = 44,
	MUSE_FLUID_SOUNDFONT_LOAD,
	MUSE_FLUID_CLIENT_SEND_CHANNELINFO,
	MUSE_FLUID_CLIENT_RESTORE_CHANNELDATA,
	MUSE_FLUID_CLIENT_INIT_PARAMS,
	MUSE_FLUID_CLIENT_LASTDIR_CHANGE,

	MUSE_FLUID_GUI_REQ_SOUNDFONTS = 60,
	MUSE_FLUID_GUI_REQ_FXPARAMETER_SET,
	MUSE_FLUID_GUI_REQ_FXPARAMETER_GET,
	MUSE_FLUID_GUI_SEND_ERROR,
	MUSE_FLUID_GUI_SOUNDFONT_CHANNEL_SET,
	MUSE_FLUID_GUI_LASTDIR_CHANGE
};

class FLUIDSynthGui_soundfont
{
public:
	FLUIDSynthGui_soundfont(): _id(0), _name("") {};

	int			_id;
	QString 		_name;
};

class FLUIDSynthGui : public FLUIDSynthGuiBase, public MidiRawIn {

Q_OBJECT

private:
	unsigned _smallH;
	unsigned _bigH;
	QSocketNotifier * _notifier;
	bool sendSysex (const unsigned char *, int);
	bool sendParameterChange (int, const char *, int);
	void setParameter (int, const char *, double);
	void requestAllParameters ();
	bool sendParameterRequest(int, const char *);
	void sendChannelChange(unsigned char font_id, unsigned char channel);
	void dealWithSysex (unsigned char const * data, int datalen);
	std::list<FLUIDSynthGui_soundfont> _soundfontStack;
	void updateSoundfontListView();
	int getSoundFontId(QString q);
	QString getSoundFontName(int id);
	QString _lastDir;
	int _currentlySelectedFont; //Font currently selected in sfListView. -1 if none selected
	void FLUIDSynthGui::assignSaneTextFont(QWidget* widget, int pointsize, const char** fontlist, int nr_of_fonts);


private slots:
	void readData(int);
	void pushClicked ();
	void popClicked ();
	void fileClicked ();
	void channelItemClicked(QListViewItem* item, const QPoint&, int col);
	void sfItemClicked(QListViewItem* item, const QPoint&, int col);
protected:
public:
	virtual void sysexReceived (const unsigned char *, int);
	virtual void eventReceived (int, int, int);
	FLUIDSynthGui ();
	~FLUIDSynthGui ();
public slots:
	void toggleReverb (bool);
	void toggleChorus (bool);
	void changeGain (int);
	void changeReverbRoomSize (int);
	void changeReverbDamping (int);
	void changeReverbWidth (int);
	void changeReverbLevel (int);
	void changeChorusNumber (int);
	void changeChorusType (int);
	void changeChorusSpeed (int);
	void changeChorusDepth (int);
	void changeChorusLevel (int);
};



#endif /* __MUSE_FLUIDSYNTHGUI_H__ */
