//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: sconfig.h,v 1.1.1.1 2003/10/29 10:05:26 wschweer Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SCONFIG_H__
#define __SCONFIG_H__

#include <list>
#include <qdialog.h>
#include "key.h"
#include "song.h"

class QScrollBar;
class QGroupBox;
class QListBox;
class QListBoxItem;
class ScoreLabel;
class QComboBox;
class QCheckBox;
class MidiTrack;
class QLineEdit;
class PitchEdit;
class QRadioButton;
class QButtonGroup;

struct PTrack {
      MidiTrack* track;
      int noteQuant;
      int restQuant;
      Scale scale;
      NKey key;
      Scale scaleL;
      NKey keyL;
      int splitpoint;
      StaffMode mode;
      };

typedef std::list<PTrack> PTrackList;
typedef PTrackList::iterator iPTrack;

//---------------------------------------------------------
//   ScoreLabel
//---------------------------------------------------------

class ScoreLabel : public QWidget {
      NKey key;
      Scale scale;
      virtual void paintEvent(QPaintEvent*);
      Q_OBJECT

   public slots:
      void setKey(int);
      void setScale(int);

   public:
      ScoreLabel(QWidget*, const char* name=0);
      NKey getKey() const    { return key;   }
      Scale getScale() const { return scale; }
      };

//---------------------------------------------------------
//   ScoreConfig
//---------------------------------------------------------

class ScoreConfig : public QDialog
      {
      QListBox* tl;

      QWidget* w1;
      QGroupBox* w2;
      PTrackList tracks;
      PTrack* track;
      ScoreLabel* canvas;
      QComboBox* quant1;
      QComboBox* quant2;
      QCheckBox* cb1;
      PitchEdit* splitpoint;
      QRadioButton* upper;
      QRadioButton* lower;
      QButtonGroup* bg;
      QScrollBar* sb1;
      QScrollBar* sb2;

      Q_OBJECT
      void setTrack(PTrack*);
      void updateCurrentTrack();

   private slots:
      void apply();
      void ok();
      void abort();
      void setSplit(bool);
      void setSplitpoint(int);
      void selectStaff(int val);
      void setKey(int);
      void setScale(int);
      void trackSelected(QListBoxItem*);

   signals:
      void trackChanged(int);

   public:
      ScoreConfig(QWidget*, const char* name=0);
      void setTracklist(TrackList* t);
      };

#endif

