//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: mpevent.h,v 1.1.1.1 2003/10/29 10:05:08 wschweer Exp $
//
//  (C) Copyright 1999-2002 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __MPEVENT_H__
#define __MPEVENT_H__

#include <map>
#include "memory.h"

class MidiEvent;
class EvData;

//---------------------------------------------------------
//   MidiPlayEvent
//---------------------------------------------------------

class MidiPlayEvent {
      unsigned char _port, _channel, _type, _a, _b;
      EvData* edata;

   public:
      MidiPlayEvent();
      MidiPlayEvent(const MidiPlayEvent&);
      MidiPlayEvent(int p, int c, int t, int a, int b)
        : _port(p), _channel(c), _type(t), _a(a), _b(b) {
            edata = 0;
            }
      MidiPlayEvent(int p, const unsigned char* data, int len);
      MidiPlayEvent(int p, EvData* data);
      MidiPlayEvent& operator=(const MidiPlayEvent&);

      ~MidiPlayEvent();
      int port()    const      { return _port;    }
      int channel() const      { return _channel; }
      int type()    const      { return _type;    }
      void setType(int val)    { _type = val;     }
      void setPort(int val)    { _port = val;     }
      void setChannel(int val) { _channel = val;  }
      int dataA()   const      { return _a;       }
      int dataB()   const      { return _b;       }
      void setA(int val)       { _a = val;        }
      void setB(int val)       { _b = val;        }
      const unsigned char* data() const;
      int len() const;
      void dump() const;
      bool isNote() const      { return _type == 0x90; }
      bool isNoteOff() const {
            return (_type == 0x80)||(_type == 0x90 && _b == 0);
            }
      EvData* eventData() const { return edata; }
      void play() const;
      };

//---------------------------------------------------------
//   MPEventList
//---------------------------------------------------------

typedef std::multimap<int, MidiPlayEvent, std::less<int>, RTalloc<MidiPlayEvent> > MPEL;
typedef std::pair<const int, MidiPlayEvent> MPEP;

struct MPEventList : public MPEL {
      void add(int tick, int a, int b, int c, int d, int e) {
            MPEL::insert(MPEP (tick, MidiPlayEvent(a,b,c,d,e)));
            }
      void add(int tick, int port, EvData* ed) {
            MPEL::insert(MPEP (tick, MidiPlayEvent(port, ed)));
            }
      void add(int tick, const MidiEvent* e, int port, int channel);
      void play() const;
      };

typedef MPEventList::iterator iMPEvent;
typedef MPEventList::const_iterator ciMPEvent;
typedef std::pair <iMPEvent, iMPEvent> MPEventRange;

#endif

